/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLUtils {
    public static void checkSupportForJAXP15Properties() {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException e) {
                classes.add(transformerFactory.getClass().getName());
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (SAXException e) {
                classes.add(schemaFactory.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to check support for JAXP 1.5 properties", e);
        }
        if (!classes.isEmpty()) {
            throw new IllegalStateException("JAXP 1.5 properties are not supported by: " + String.join((CharSequence)", ", classes));
        }
    }

    public static String removeXMLInvalidChars(String in) {
        if (in == null || "".equals(in)) {
            return in;
        }
        int lenght = in.length();
        int invalid = 0;
        for (int i = 0; i < lenght; ++i) {
            char current = in.charAt(i);
            if (XMLUtils.isXMLValidChar(current)) continue;
            ++invalid;
        }
        if (invalid > 0) {
            StringBuilder out = new StringBuilder(in.length() - invalid);
            for (int i = 0; i < lenght; ++i) {
                char current = in.charAt(i);
                if (!XMLUtils.isXMLValidChar(current)) continue;
                out.append(current);
            }
            in = out.toString();
        }
        return in;
    }

    public static QName qName(String name, NamespaceSupport namespaces) {
        int dot = name.indexOf(58);
        if (dot > -1) {
            String[] split = name.split(":");
            String prefix = split[0];
            String local = split[1];
            return new QName(namespaces.getURI(prefix), local, prefix);
        }
        return new QName(name);
    }

    private static boolean isXMLValidChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }
}

