/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.util.ObjectCache;
import org.geotools.util.WeakValueHashMap;

final class FixedSizeObjectCache<K, V>
implements ObjectCache<K, V> {
    private final int LIMIT;
    private final Map<K, V> cache;
    private final Map<K, ReentrantLock> locks;

    public FixedSizeObjectCache() {
        this(50);
    }

    public FixedSizeObjectCache(int initialSize) {
        this.LIMIT = initialSize;
        this.cache = Collections.synchronizedMap(new WeakValueHashMap(initialSize));
        this.locks = new HashMap<K, ReentrantLock>(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.clear();
            this.cache.clear();
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public V peek(K key) {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLock(K key) {
        ReentrantLock lock;
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.getHoldCount() == 0) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.unlock();
            if (lock.getHoldCount() == 0) {
                this.locks.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean holdsLock(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(key);
            if (lock != null) {
                return lock.getHoldCount() != 0;
            }
        }
        return false;
    }

    @Override
    public void put(K key, V object) {
        if (this.cache.size() < this.LIMIT) {
            this.writeLock(key);
            this.cache.put(key, object);
            this.writeUnLock(key);
        }
    }

    @Override
    public Set<K> getKeys() {
        return new HashSet<K>(this.cache.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.remove(key);
            this.cache.remove(key);
        }
    }
}

