/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.GraphicImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class StrokeImpl
implements Stroke,
Cloneable {
    private FilterFactory filterFactory;
    private Expression color;
    private List<Expression> dashArray;
    private Expression dashOffset;
    private GraphicImpl fillGraphic;
    private GraphicImpl strokeGraphic;
    private Expression lineCap;
    private Expression lineJoin;
    private Expression opacity;
    private Expression width;
    public static Stroke DEFAULT = new Stroke.ConstantStroke(){

        @Override
        public Expression getColor() {
            return ConstantExpression.BLACK;
        }

        @Override
        public Expression getWidth() {
            return ConstantExpression.ONE;
        }

        @Override
        public Expression getOpacity() {
            return ConstantExpression.ONE;
        }

        @Override
        public Expression getLineJoin() {
            return ConstantExpression.constant("miter");
        }

        @Override
        public Expression getLineCap() {
            return ConstantExpression.constant("butt");
        }

        @Override
        public float[] getDashArray() {
            return null;
        }

        @Override
        public List<Expression> dashArray() {
            return null;
        }

        @Override
        public Expression getDashOffset() {
            return ConstantExpression.ZERO;
        }

        @Override
        public Graphic getGraphicFill() {
            return GraphicImpl.DEFAULT;
        }

        @Override
        public Graphic getGraphicStroke() {
            return GraphicImpl.NULL;
        }

        public Object clone() {
            return this;
        }
    };
    public static final Stroke NULL = new Stroke.ConstantStroke(){

        @Override
        public Expression getColor() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getWidth() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getOpacity() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getLineJoin() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getLineCap() {
            return ConstantExpression.NULL;
        }

        @Override
        public float[] getDashArray() {
            return new float[0];
        }

        @Override
        public List<Expression> dashArray() {
            return Collections.emptyList();
        }

        @Override
        public Expression getDashOffset() {
            return ConstantExpression.NULL;
        }

        @Override
        public Graphic getGraphicFill() {
            return GraphicImpl.NULL;
        }

        @Override
        public Graphic getGraphicStroke() {
            return GraphicImpl.NULL;
        }
    };

    protected StrokeImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected StrokeImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    @Override
    public Expression getColor() {
        return this.color;
    }

    @Override
    public void setColor(Expression color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
    }

    public void setColor(String color) {
        this.setColor(this.filterFactory.literal(color));
    }

    @Override
    public float[] getDashArray() {
        if (this.dashArray == null) {
            return DEFAULT.getDashArray();
        }
        float[] values = new float[this.dashArray.size()];
        int index = 0;
        for (Expression expression : this.dashArray) {
            if (!(expression instanceof Literal)) {
                throw new RuntimeException("Dash array is not literal: '" + expression + "'.");
            }
            Literal literal = (Literal)expression;
            values[index] = literal.evaluate(null, Float.class).floatValue();
            ++index;
        }
        return values;
    }

    @Override
    public void setDashArray(float[] literalDashArray) {
        if (literalDashArray != null) {
            this.dashArray = new ArrayList<Expression>(literalDashArray.length);
            for (float value : literalDashArray) {
                this.dashArray.add(this.filterFactory.literal(value));
            }
        }
    }

    @Override
    public List<Expression> dashArray() {
        if (this.dashArray == null) {
            return DEFAULT.dashArray();
        }
        return this.dashArray;
    }

    @Override
    public void setDashArray(List<Expression> dashArray) {
        this.dashArray = dashArray;
    }

    @Override
    public Expression getDashOffset() {
        if (this.dashOffset == null) {
            return DEFAULT.getDashOffset();
        }
        return this.dashOffset;
    }

    @Override
    public void setDashOffset(Expression dashOffset) {
        if (dashOffset == null) {
            return;
        }
        this.dashOffset = dashOffset;
    }

    @Override
    public Graphic getGraphicFill() {
        return this.fillGraphic;
    }

    @Override
    public void setGraphicFill(Graphic fillGraphic) {
        if (this.fillGraphic == fillGraphic) {
            return;
        }
        this.fillGraphic = GraphicImpl.cast(fillGraphic);
    }

    @Override
    public Graphic getGraphicStroke() {
        return this.strokeGraphic;
    }

    @Override
    public void setGraphicStroke(Graphic strokeGraphic) {
        if (this.strokeGraphic == strokeGraphic) {
            return;
        }
        this.strokeGraphic = GraphicImpl.cast(strokeGraphic);
    }

    @Override
    public Expression getLineCap() {
        if (this.lineCap == null) {
            return DEFAULT.getLineCap();
        }
        return this.lineCap;
    }

    @Override
    public void setLineCap(Expression lineCap) {
        if (lineCap == null) {
            return;
        }
        this.lineCap = lineCap;
    }

    @Override
    public Expression getLineJoin() {
        if (this.lineCap == null) {
            return DEFAULT.getLineJoin();
        }
        return this.lineJoin;
    }

    @Override
    public void setLineJoin(Expression lineJoin) {
        if (lineJoin == null) {
            return;
        }
        this.lineJoin = lineJoin;
    }

    @Override
    public Expression getOpacity() {
        if (this.lineCap == null) {
            return DEFAULT.getOpacity();
        }
        return this.opacity;
    }

    @Override
    public void setOpacity(Expression opacity) {
        if (opacity == null) {
            return;
        }
        this.opacity = opacity;
    }

    @Override
    public Expression getWidth() {
        if (this.width == null) {
            return this.filterFactory.literal(1.0);
        }
        return this.width;
    }

    @Override
    public void setWidth(Expression width) {
        this.width = width;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("org.geotools.styling.StrokeImpl:\n");
        out.append("\tColor " + this.color + "\n");
        out.append("\tWidth " + this.width + "\n");
        out.append("\tOpacity " + this.opacity + "\n");
        out.append("\tLineCap " + this.lineCap + "\n");
        out.append("\tLineJoin " + this.lineJoin + "\n");
        out.append("\tDash Array " + this.dashArray + "\n");
        out.append("\tDash Offset " + this.dashOffset + "\n");
        out.append("\tFill Graphic " + this.fillGraphic + "\n");
        out.append("\tStroke Graphic " + this.strokeGraphic);
        return out.toString();
    }

    public Color getColor(SimpleFeature feature) {
        return Color.decode((String)this.getColor().evaluate(feature));
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            StrokeImpl clone = (StrokeImpl)super.clone();
            if (this.dashArray != null) {
                clone.setDashArray(new ArrayList<Expression>(this.dashArray));
            }
            if (this.fillGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.fillGraphic = (GraphicImpl)this.fillGraphic.clone();
            }
            if (this.strokeGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.strokeGraphic = (GraphicImpl)this.strokeGraphic.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone StrokeImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.dashOffset != null) {
            result = 1000003 * result + this.dashOffset.hashCode();
        }
        if (this.fillGraphic != null) {
            result = 1000003 * result + this.fillGraphic.hashCode();
        }
        if (this.strokeGraphic != null) {
            result = 1000003 * result + this.strokeGraphic.hashCode();
        }
        if (this.lineCap != null) {
            result = 1000003 * result + this.lineCap.hashCode();
        }
        if (this.lineJoin != null) {
            result = 1000003 * result + this.lineJoin.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.width != null) {
            result = 1000003 * result + this.width.hashCode();
        }
        if (this.dashArray != null) {
            result = 1000003 * result + this.dashArray.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        StrokeImpl other = (StrokeImpl)oth;
        if (!Utilities.equals(this.getColor(), other.getColor())) {
            return false;
        }
        if (!Utilities.equals(this.getWidth(), other.getWidth())) {
            return false;
        }
        if (!Utilities.equals(this.getLineCap(), other.getLineCap())) {
            return false;
        }
        if (!Utilities.equals(this.getLineJoin(), other.getLineJoin())) {
            return false;
        }
        if (!Utilities.equals(this.getOpacity(), other.getOpacity())) {
            return false;
        }
        if (!Utilities.equals(this.getGraphicFill(), other.getGraphicFill())) {
            return false;
        }
        if (!Utilities.equals(this.getGraphicStroke(), other.getGraphicStroke())) {
            return false;
        }
        return Utilities.equals(this.dashArray(), other.dashArray());
    }

    static StrokeImpl cast(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        if (stroke instanceof StrokeImpl) {
            return (StrokeImpl)stroke;
        }
        StrokeImpl copy = new StrokeImpl();
        copy.setColor(stroke.getColor());
        copy.setDashArray(stroke.getDashArray());
        copy.setDashOffset(stroke.getDashOffset());
        copy.setGraphicFill(GraphicImpl.cast(stroke.getGraphicFill()));
        copy.setGraphicStroke(GraphicImpl.cast(stroke.getGraphicStroke()));
        copy.setLineCap(stroke.getLineCap());
        copy.setLineJoin(stroke.getLineJoin());
        copy.setOpacity(stroke.getOpacity());
        copy.setWidth(stroke.getWidth());
        return copy;
    }
}

