/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ContrastMethod;
import org.geotools.api.style.ContrastMethodStrategy;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.factory.CommonFactoryFinder;

public class ContrastEnhancementImpl
implements ContrastEnhancement {
    private FilterFactory filterFactory;
    private Expression gamma;
    private ContrastMethod method;
    private Map<String, Expression> options;

    public ContrastEnhancementImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public ContrastEnhancementImpl(FilterFactory factory) {
        this(factory, null);
    }

    public ContrastEnhancementImpl(FilterFactory factory, ContrastMethod method) {
        this.filterFactory = factory;
        this.method = method;
    }

    public ContrastEnhancementImpl(ContrastEnhancement contrastEnhancement) {
        ContrastEnhancement other;
        this.filterFactory = CommonFactoryFinder.getFilterFactory(null);
        ContrastMethod meth = contrastEnhancement.getMethod();
        if (meth != null) {
            this.method = ContrastMethod.valueOf(meth.name());
        }
        this.gamma = contrastEnhancement.getGammaValue();
        if (contrastEnhancement instanceof ContrastEnhancement && (other = contrastEnhancement).getOptions() != null) {
            this.options = new HashMap<String, Expression>();
            this.options.putAll(other.getOptions());
        }
    }

    public ContrastEnhancementImpl(FilterFactory factory, Expression gamma, ContrastMethod method) {
        this.filterFactory = factory;
        this.gamma = gamma;
        this.method = method;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    @Override
    public Expression getGammaValue() {
        return this.gamma;
    }

    @Override
    public void setGammaValue(Expression gamma) {
        this.gamma = gamma;
    }

    @Override
    public ContrastMethod getMethod() {
        return this.method;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    static ContrastEnhancementImpl cast(ContrastEnhancement enhancement) {
        if (enhancement == null) {
            return null;
        }
        if (enhancement instanceof ContrastEnhancementImpl) {
            return (ContrastEnhancementImpl)enhancement;
        }
        ContrastEnhancementImpl copy = new ContrastEnhancementImpl();
        copy.setGammaValue(enhancement.getGammaValue());
        copy.setMethod(enhancement.getMethod());
        return copy;
    }

    @Override
    public void setMethod(ContrastMethod method) {
        this.method = method;
    }

    @Override
    public Map<String, Expression> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        return this.options;
    }

    @Override
    public boolean hasOption(String key) {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        return this.options.containsKey(key);
    }

    @Override
    public Expression getOption(String key) {
        return this.options.get(key);
    }

    @Override
    public void addOption(String key, Expression value) {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        this.options.put(key, value);
    }

    @Override
    public void setOptions(Map<String, Expression> options) {
        this.options = options;
    }

    @Override
    public void setMethod(ContrastMethodStrategy method) {
        this.method = method.getMethod();
        this.options = method.getOptions();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gamma == null ? 0 : this.gamma.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContrastEnhancementImpl)) {
            return false;
        }
        ContrastEnhancementImpl other = (ContrastEnhancementImpl)obj;
        if (this.gamma == null ? other.gamma != null : !this.gamma.equals(other.gamma)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }
}

