/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class LongitudeFirstFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
CoordinateOperationAuthorityFactory,
DatumAuthorityFactory {
    public LongitudeFirstFactory() {
        this((Hints)null);
    }

    public LongitudeFirstFactory(Hints userHints) {
        super(userHints, 90 + LongitudeFirstFactory.relativePriority());
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints userHints, Hints.Key key) {
        Object value = null;
        if (userHints != null) {
            value = userHints.get(key);
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority() {
        try {
            if (Boolean.getBoolean("org.geotools.referencing.forceXY")) {
                return 7;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -7;
    }

    @Override
    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        Hints backingStoreHints = new Hints(Hints.CRS_AUTHORITY_FACTORY, ThreadedEpsgFactory.class);
        backingStoreHints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        backingStoreHints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        backingStoreHints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        try {
            factory = (AbstractAuthorityFactory)((Object)ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", backingStoreHints));
        }
        catch (org.geotools.util.factory.FactoryNotFoundException exception) {
            throw new FactoryNotFoundException(exception);
        }
        catch (FactoryRegistryException exception) {
            throw new FactoryException(exception);
        }
        return new OrderedAxisAuthorityFactory(factory, new Hints(this.hints), null);
    }
}

