/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.Collection;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.filter.Filters;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.util.Utilities;

public class MultiplyImpl
extends MathExpressionImpl
implements Multiply {
    public MultiplyImpl(Expression expr1, Expression expr2) {
        super(expr1, expr2);
    }

    @Override
    public Object evaluate(Object feature) throws IllegalArgumentException {
        this.ensureOperandsSet();
        Object eval1 = this.getExpression1().evaluate(feature);
        Object eval2 = this.getExpression2().evaluate(feature);
        if (eval1 instanceof Collection || eval2 instanceof Collection) {
            return this.handleCollection(eval1, eval2);
        }
        double leftDouble = Filters.number(this.getExpression1().evaluate(feature, Number.class));
        double rightDouble = Filters.number(this.getExpression2().evaluate(feature, Number.class));
        return this.doArithmeticOperation(leftDouble, rightDouble);
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiplyImpl) {
            MultiplyImpl other = (MultiplyImpl)obj;
            return Utilities.equals(this.getExpression1(), other.getExpression1()) && Utilities.equals(this.getExpression2(), other.getExpression2());
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.getExpression1().hashCode();
        result = 37 * result + this.getExpression2().hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.getExpression1().toString() + "*" + this.getExpression2().toString() + ")";
    }

    @Override
    protected Object doArithmeticOperation(Double operand1, Double operand2) {
        return this.number(operand1 * operand2);
    }
}

