/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.filter.capability.ComparisonOperators;
import org.geotools.api.filter.capability.Operator;

public class ComparisonOperatorsImpl
implements ComparisonOperators {
    Set<Operator> operators;

    public ComparisonOperatorsImpl() {
        this(new ArrayList<Operator>());
    }

    public ComparisonOperatorsImpl(ComparisonOperators copy) {
        this.operators = new HashSet<Operator>(copy.getOperators());
    }

    public ComparisonOperatorsImpl(Collection<Operator> operators) {
        this.operators = new HashSet<Operator>(operators);
    }

    public ComparisonOperatorsImpl(Operator ... operators) {
        if (operators == null) {
            operators = new Operator[]{};
        }
        this.operators = new HashSet<Operator>(Arrays.asList(operators));
    }

    @Override
    public Collection<Operator> getOperators() {
        if (this.operators == null) {
            this.operators = new HashSet<Operator>();
        }
        return this.operators;
    }

    public void setOperators(Collection<Operator> operators) {
        this.operators = new HashSet<Operator>(operators);
    }

    @Override
    public Operator getOperator(String name) {
        if (name == null || this.operators == null) {
            return null;
        }
        for (Operator operator : this.operators) {
            if (!name.equals(operator.getName())) continue;
            return operator;
        }
        return null;
    }

    public void addAll(ComparisonOperators copy) {
        if (copy.getOperators() != null) {
            this.getOperators().addAll(copy.getOperators());
        }
    }

    public String toString() {
        if (this.operators == null) {
            return "ComparisonOperators: none";
        }
        return "ComparisonOperators:" + this.operators;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operators == null ? 0 : this.operators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparisonOperatorsImpl other = (ComparisonOperatorsImpl)obj;
        return !(this.operators == null ? other.operators != null : !this.operators.equals(other.operators));
    }
}

