/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class InterpolationConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(InterpolationConverterFactory.class);
    private static final InterpolationConverter THE_INTERPOLATION_CONVERTER = new InterpolationConverter();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source == null || target == null || !source.equals(String.class)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("InterpolationConverterFactory can be applied from Strings to Interpolation only.");
            }
            return null;
        }
        if (Interpolation.class.isAssignableFrom(target)) {
            return THE_INTERPOLATION_CONVERTER;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("InterpolationConverterFactory can be applied from Strings to Interpolation  only.");
        }
        return null;
    }

    static enum InterpolationParser {
        INTERPOLATIONNEAREST{
            private final InterpolationNearest INTERPOLATION_NEAREST = new InterpolationNearest();

            @Override
            Interpolation parse(String interpolationString) {
                if (interpolationString.equals("InterpolationNearest")) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Parsed InterpolationNearest");
                    }
                    return this.INTERPOLATION_NEAREST;
                }
                return null;
            }
        }
        ,
        INTERPOLATIONBILINEAR{
            private final InterpolationBilinear INTERPOLATION_BILINEAR = new InterpolationBilinear();
            private final Pattern INTERPOLATION_BILINEAR_PATTERN_MATCH = Pattern.compile("InterpolationBilinear\\(\\d+\\)");
            private final Pattern INTERPOLATION_BILINEAR_PATTERN_EXTRACT = Pattern.compile("\\d+");

            @Override
            Interpolation parse(String interpolationString) {
                block6: {
                    if (interpolationString.equals("InterpolationBilinear")) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Parsing InterpolationBilinear=" + interpolationString);
                        }
                        return this.INTERPOLATION_BILINEAR;
                    }
                    Matcher matcher = this.INTERPOLATION_BILINEAR_PATTERN_MATCH.matcher(interpolationString);
                    if (matcher.matches()) {
                        matcher = this.INTERPOLATION_BILINEAR_PATTERN_EXTRACT.matcher(interpolationString);
                        matcher.matches();
                        if (matcher.find()) {
                            String subsBitsString = matcher.group();
                            try {
                                return new InterpolationBilinear(Integer.parseInt(subsBitsString));
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
                return null;
            }
        }
        ,
        INTERPOLATIONBICUBIC{
            private final Pattern INTERPOLATION_BICUBIC_PATTERN_MATCH = Pattern.compile("InterpolationBicubic\\(\\d+\\)");
            private final Pattern INTERPOLATION_BICUBIC_PATTERN_EXTRACT = Pattern.compile("\\d+");

            @Override
            Interpolation parse(String interpolationString) {
                block4: {
                    Matcher matcher = this.INTERPOLATION_BICUBIC_PATTERN_MATCH.matcher(interpolationString);
                    if (matcher.matches()) {
                        matcher = this.INTERPOLATION_BICUBIC_PATTERN_EXTRACT.matcher(interpolationString);
                        matcher.matches();
                        if (matcher.find()) {
                            String subsBitsString = matcher.group();
                            try {
                                return new InterpolationBicubic(Integer.parseInt(subsBitsString));
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
                return null;
            }
        }
        ,
        INTERPOLATIONBICUBIC2{
            private final Pattern INTERPOLATION_BICUBIC2_PATTERN_MATCH = Pattern.compile("InterpolationBicubic2\\(\\d+\\)");
            private final Pattern INTERPOLATION_BICUBIC2_PATTERN_EXTRACT = Pattern.compile("\\d+");

            @Override
            Interpolation parse(String interpolationString) {
                block4: {
                    Matcher matcher = this.INTERPOLATION_BICUBIC2_PATTERN_MATCH.matcher(interpolationString);
                    if (matcher.matches()) {
                        matcher = this.INTERPOLATION_BICUBIC2_PATTERN_EXTRACT.matcher(interpolationString);
                        matcher.matches();
                        if (matcher.find()) {
                            String subsBitsString = matcher.group();
                            try {
                                return new InterpolationBicubic2(Integer.parseInt(subsBitsString));
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                }
                return null;
            }
        };


        abstract Interpolation parse(String var1);
    }

    static class InterpolationConverter
    implements Converter {
        InterpolationConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            Interpolation output;
            if (source == null) {
                return null;
            }
            if (target == null || !Interpolation.class.isAssignableFrom(target)) {
                return null;
            }
            String input = (String)source;
            int idx = (input = input.trim()).indexOf(40);
            String key = idx == -1 ? input.toUpperCase() : input.substring(0, idx).toUpperCase();
            InterpolationParser parser = InterpolationParser.valueOf(key);
            if (parser == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("InterpolationConverterFactory can be applied to Strings like interpolation????(XXX). " + source + " is invalid!");
            }
            if ((output = parser.parse(input)) == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to parse " + input);
            }
            return (T)output;
        }
    }
}

