/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.AttributeReader;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class DefaultFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    protected final Object[] attributes;

    public DefaultFeatureReader(AttributeReader attributeReader, SimpleFeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
    }

    public DefaultFeatureReader(AttributeReader attributeReader) throws SchemaException {
        this(attributeReader, null);
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        SimpleFeature f = null;
        if (this.attributeReader.hasNext()) {
            this.attributeReader.next();
            f = this.readFeature(this.attributeReader);
        }
        return f;
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        int ii = this.attributeReader.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            builder.add(this.attributeReader.getAttributeType(i));
        }
        return builder.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.attributes[i] = atts.read(i);
        }
        return SimpleFeatureBuilder.build(this.schema, this.attributes, null);
    }

    @Override
    public void close() throws IOException {
        this.attributeReader.close();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.attributeReader.hasNext();
    }
}

