/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;

public class Absolute
extends BaseMathOperationJAI {
    private static final String ALGEBRIC = "algebric";
    private static final String ABSOLUTE = "Absolute";
    private static final long serialVersionUID = 3723059532452772794L;

    public Absolute() {
        super(ABSOLUTE, Absolute.getOperationDescriptor(JAIExt.getOperationName(ABSOLUTE)));
    }

    @Override
    public String getName() {
        return ABSOLUTE;
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        NumberRange<? extends Number> range = ranges[0];
        double min = Math.abs(range.getMinimum());
        double max = Math.abs(range.getMaximum());
        return max < min ? NumberRange.create(max, min) : NumberRange.create(min, max);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation(ALGEBRIC)) {
            parameters.set((Object)AlgebraDescriptor.Operator.ABSOLUTE, 0);
            Collection sources = (Collection)parameters2.parameter("sources").getValue();
            for (GridCoverage2D source : sources) {
                Absolute.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
            }
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Absolute.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

