/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffException;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataEncoder;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.operation.projection.AlbersEqualArea;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.referencing.operation.projection.ObliqueMercator;
import org.geotools.referencing.operation.projection.ObliqueStereographic;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.referencing.operation.projection.Sinusoidal;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.geotools.referencing.operation.projection.WorldVanDerGrintenI;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.util.CRSUtilities;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.AbstractUnit;

public final class CRS2GeoTiffMetadataAdapter {
    private CoordinateReferenceSystem crs;

    public CRS2GeoTiffMetadataAdapter(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    private static int getEPSGCode(IdentifiedObject obj) {
        Set<ReferenceIdentifier> identifiers = obj.getIdentifiers();
        Iterator<ReferenceIdentifier> it = identifiers.iterator();
        String code = "";
        while (it.hasNext()) {
            Identifier identifier = it.next();
            Citation cite = identifier.getAuthority();
            if (!Citations.identifierMatches(cite, "EPSG")) continue;
            code = identifier.getCode();
            break;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public GeoTiffIIOMetadataEncoder parseCoordinateReferenceSystem() throws GeoTiffException {
        GeoTiffIIOMetadataEncoder metadata = new GeoTiffIIOMetadataEncoder();
        int modelType = this.crs instanceof ProjectedCRS ? 1 : 2;
        metadata.addGeoShortParam(1024, modelType);
        switch (modelType) {
            case 2: {
                this.parseGeoGCS((DefaultGeographicCRS)this.crs, metadata);
                break;
            }
            case 1: {
                this.parseProjCRS((ProjectedCRS)this.crs, metadata);
                break;
            }
            default: {
                throw new GeoTiffException(null, "The supplied grid coverage uses an unsupported crs! You are allowed to use only projected and geographic coordinate reference systems", null);
            }
        }
        return metadata;
    }

    private void parseProjCRS(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(projectedCRS);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(3072, code);
            return;
        }
        metadata.addGeoShortParam(3072, Short.MAX_VALUE);
        metadata.addGeoAscii(3073, projectedCRS.getName().getCode());
        this.parseProjection(projectedCRS, metadata);
        this.parseGeoGCS((DefaultGeographicCRS)projectedCRS.getBaseCRS(), metadata);
    }

    private void parseProjection(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        MapProjection projTransf;
        Projection conversion = projectedCRS.getConversionFromBase();
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(conversion);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(3074, code);
            return;
        }
        metadata.addGeoShortParam(3074, Short.MAX_VALUE);
        OperationMethod method = conversion.getMethod();
        String name = method.getName().getCode();
        name = name.trim();
        name = name.replace(' ', '_');
        MathTransform mt = conversion.getMathTransform();
        if (!(mt instanceof ConcatenatedTransform)) {
            projTransf = (MapProjection)mt;
        } else {
            ConcatenatedTransform tr = (ConcatenatedTransform)mt;
            MathTransform m1 = tr.transform1;
            MathTransform m2 = tr.transform2;
            projTransf = m1 instanceof MapProjection ? (MapProjection)m1 : (MapProjection)m2;
        }
        this.parseCoordinateProjectionTransform(projTransf, name, metadata);
        this.parseLinearUnit(projectedCRS, metadata);
    }

    private void parseLinearUnit(ProjectedCRS projectedCRS, GeoTiffIIOMetadataEncoder metadata) {
        Unit<?> unit = CRSUtilities.getUnit(projectedCRS.getCoordinateSystem());
        if (unit != null && !SI.METRE.isCompatible(unit)) {
            throw new IllegalArgumentException(MessageFormat.format("\"{0}\" is not a linear unit.", unit));
        }
        Unit<?> linearUnit = unit;
        if (SI.METRE.equals(linearUnit)) {
            metadata.addGeoShortParam(3076, 9001);
            metadata.addGeoDoubleParam(3077, 1.0);
        } else if (USCustomary.NAUTICAL_MILE.equals(linearUnit)) {
            metadata.addGeoShortParam(3076, 9015);
            metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METRE).convert(1.0));
        } else if (USCustomary.FOOT.equals(linearUnit)) {
            metadata.addGeoShortParam(3076, 9002);
            metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METRE).convert(1.0));
        } else if (USCustomary.YARD.equals(linearUnit)) {
            metadata.addGeoShortParam(3076, 9012);
            metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METRE).convert(1.0));
        } else if (USCustomary.FOOT_SURVEY.equals(linearUnit)) {
            metadata.addGeoShortParam(3076, 9003);
            metadata.addGeoDoubleParam(3077, linearUnit.getConverterTo(SI.METRE).convert(1.0));
        }
    }

    private void parseCoordinateProjectionTransform(MapProjection projTransf, String name, GeoTiffIIOMetadataEncoder metadata) {
        ParameterValueGroup parameters = projTransf.getParameterValues();
        if (projTransf instanceof TransverseMercator && name.equalsIgnoreCase("transverse_mercator")) {
            metadata.addGeoShortParam(3075, 1);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof Mercator && (name.equalsIgnoreCase("mercator_1SP") || name.equalsIgnoreCase("Mercator_2SP"))) {
            metadata.addGeoShortParam(3075, 7);
            List<GeneralParameterValue> values = parameters.values();
            for (GeneralParameterValue value : values) {
                if (!(value instanceof ParameterValue)) continue;
                ParameterValue paramValue = (ParameterValue)value;
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "latitude_of_origin")) {
                    metadata.addGeoDoubleParam(3081, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "central_meridian")) {
                    metadata.addGeoDoubleParam(3080, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "scale_factor")) {
                    metadata.addGeoDoubleParam(3092, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "standard_parallel_1")) {
                    metadata.addGeoDoubleParam(3078, paramValue.doubleValue());
                    continue;
                }
                if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "false_easting")) {
                    metadata.addGeoDoubleParam(3082, paramValue.doubleValue());
                    continue;
                }
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), "false_northing")) continue;
                metadata.addGeoDoubleParam(3083, paramValue.doubleValue());
            }
            return;
        }
        if (projTransf instanceof LambertConformal && name.indexOf("1") != -1) {
            metadata.addGeoShortParam(3075, 9);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof LambertConformal && name.indexOf("2") != -1) {
            metadata.addGeoShortParam(3075, 8);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3078, parameters.parameter("standard_parallel_1").doubleValue());
            metadata.addGeoDoubleParam(3079, parameters.parameter("standard_parallel_2").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof Stereographic && name.equalsIgnoreCase("stereographic")) {
            metadata.addGeoShortParam(3075, 14);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof PolarStereographic && name.equalsIgnoreCase("polar_stereographic")) {
            metadata.addGeoShortParam(3075, 15);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3095, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof ObliqueStereographic && name.equalsIgnoreCase("Oblique_Stereographic")) {
            metadata.addGeoShortParam(3075, 16);
            metadata.addGeoDoubleParam(3080, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3092, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof ObliqueMercator && (name.equalsIgnoreCase("oblique_mercator") || name.equalsIgnoreCase("hotine_oblique_mercator"))) {
            metadata.addGeoShortParam(3075, 3);
            metadata.addGeoDoubleParam(3088, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3089, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3093, parameters.parameter("scale_factor").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3094, parameters.parameter("azimuth").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof AlbersEqualArea && name.equalsIgnoreCase("albers_Conic_Equal_Area")) {
            metadata.addGeoShortParam(3075, 11);
            metadata.addGeoDoubleParam(3080, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3081, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            metadata.addGeoDoubleParam(3078, parameters.parameter("standard_parallel_1").doubleValue());
            metadata.addGeoDoubleParam(3079, parameters.parameter("standard_parallel_2").doubleValue());
            return;
        }
        if (projTransf instanceof Orthographic && name.equalsIgnoreCase("Orthographic")) {
            metadata.addGeoShortParam(3075, 21);
            metadata.addGeoDoubleParam(3088, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3088, parameters.parameter("latitude_of_origin").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof LambertAzimuthalEqualArea && name.equalsIgnoreCase("Lambert_Azimuthal_Equal_Area")) {
            metadata.addGeoShortParam(3075, 10);
            metadata.addGeoDoubleParam(3089, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3088, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof AzimuthalEquidistant.Abstract && name.equalsIgnoreCase("Azimuthal_Equidistant")) {
            metadata.addGeoShortParam(3075, 12);
            metadata.addGeoDoubleParam(3088, parameters.parameter("longitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3089, parameters.parameter("latitude_of_center").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof WorldVanDerGrintenI && name.equalsIgnoreCase("World_Van_der_Grinten_I")) {
            metadata.addGeoShortParam(3075, 25);
            metadata.addGeoDoubleParam(3088, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        if (projTransf instanceof Sinusoidal && name.toLowerCase().contains("sinusoidal")) {
            metadata.addGeoShortParam(3075, 24);
            metadata.addGeoDoubleParam(3088, parameters.parameter("central_meridian").doubleValue());
            metadata.addGeoDoubleParam(3082, parameters.parameter("false_easting").doubleValue());
            metadata.addGeoDoubleParam(3083, parameters.parameter("false_northing").doubleValue());
            return;
        }
        throw new IllegalArgumentException("Unable to map projection" + projTransf.getName());
    }

    private void parseGeoGCS(DefaultGeographicCRS geographicCRS, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(geographicCRS);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(2048, code);
            return;
        }
        metadata.addGeoShortParam(2048, Short.MAX_VALUE);
        metadata.addGeoAscii(2049, "GCS Name = " + geographicCRS.getName().getCode());
        DefaultGeodeticDatum datum = (DefaultGeodeticDatum)geographicCRS.getDatum();
        this.parseDatum(datum, metadata);
        Unit<?> angularUnit = geographicCRS.getCoordinateSystem().getAxis(0).getUnit();
        this.parseUnit(angularUnit, 0, metadata);
        this.parsePrimem((DefaultPrimeMeridian)datum.getPrimeMeridian(), metadata);
        Unit<Length> linearUnit = datum.getEllipsoid().getAxisUnit();
        this.parseUnit(linearUnit, 2, metadata);
    }

    private void parseDatum(DefaultGeodeticDatum datum, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(datum);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(2050, code);
            return;
        }
        metadata.addGeoShortParam(2050, Short.MAX_VALUE);
        metadata.addGeoAscii(2049, "Datum = " + datum.getName().getCode());
        this.parseSpheroid((DefaultEllipsoid)datum.getEllipsoid(), metadata);
    }

    private void parseSpheroid(DefaultEllipsoid ellipsoid, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(ellipsoid);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(2056, code);
            return;
        }
        metadata.addGeoShortParam(2056, Short.MAX_VALUE);
        metadata.addGeoAscii(2049, "Ellipsoid = " + ellipsoid.getName().getCode());
        metadata.addGeoDoubleParam(2057, ellipsoid.getSemiMajorAxis());
        metadata.addGeoDoubleParam(2059, ellipsoid.getInverseFlattening());
    }

    private void parsePrimem(DefaultPrimeMeridian pm, GeoTiffIIOMetadataEncoder metadata) {
        int code = CRS2GeoTiffMetadataAdapter.getEPSGCode(pm);
        if (GeoTiffIIOMetadataEncoder.isTiffUShort(code)) {
            metadata.addGeoShortParam(2051, code);
        } else {
            metadata.addGeoShortParam(2051, Short.MAX_VALUE);
            metadata.addGeoAscii(2049, "Primem = " + pm.getName().getCode());
            metadata.addGeoDoubleParam(2061, pm.getGreenwichLongitude());
        }
    }

    private void parseUnit(Unit<?> unit, int model, GeoTiffIIOMetadataEncoder metadata) {
        int key2;
        int key1 = -1;
        switch (model) {
            case 0: {
                key1 = 2054;
                key2 = 2055;
                break;
            }
            case 1: {
                key1 = 3076;
                key2 = 3077;
                break;
            }
            case 2: {
                key1 = 2052;
                key2 = 2053;
                break;
            }
            default: {
                throw new IllegalStateException("Unable to map model " + model + " for this unit");
            }
        }
        unit = Units.autoCorrect(unit);
        if (unit.equals(SI.METRE)) {
            metadata.addGeoShortParam(key1, 9001);
        } else if (unit.equals(USCustomary.FOOT)) {
            metadata.addGeoShortParam(key1, 9002);
        } else if (unit.equals(USCustomary.FOOT_SURVEY)) {
            metadata.addGeoShortParam(key1, 9003);
        } else if (unit.equals(USCustomary.GRADE)) {
            metadata.addGeoShortParam(key1, 9105);
        } else if (unit.equals(SI.RADIAN)) {
            metadata.addGeoShortParam(key1, 9101);
        } else if (unit.equals(NonSI.DEGREE_ANGLE)) {
            metadata.addGeoShortParam(key1, 9102);
        } else {
            metadata.addGeoShortParam(key1, Short.MAX_VALUE);
            metadata.addGeoAscii(2049, unit.toString());
            UnitConverter converter = this.getUnitConverter(unit);
            if (converter != null) {
                metadata.addGeoDoubleParam(key2, converter.convert(1.0));
            } else {
                metadata.addGeoDoubleParam(key2, 1.0);
            }
        }
    }

    private UnitConverter getUnitConverter(Unit<?> unit) {
        UnitConverter converter = null;
        if (SI.METRE.isCompatible(unit)) {
            converter = unit.getConverterTo(SI.METRE);
        } else if (SI.SECOND.isCompatible(unit)) {
            converter = unit.getConverterTo(SI.SECOND);
        } else if (SI.RADIAN.isCompatible(unit) && !AbstractUnit.ONE.equals(unit)) {
            converter = unit.getConverterTo(SI.RADIAN);
        }
        return converter;
    }
}

