/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.geotools.api.coverage.grid.GridCoordinates;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.coverage.grid.GeneralGridCoordinates;
import org.geotools.geometry.PixelTranslation;
import org.geotools.util.Classes;

public class GeneralGridEnvelope
implements GridEnvelope,
Serializable {
    private static final long serialVersionUID = -1695224412095031712L;
    private transient GridCoordinates low;
    private transient GridCoordinates high;
    private final int[] index;

    private void checkCoherence() throws IllegalArgumentException {
        int dimension = this.index.length / 2;
        for (int i = 0; i < dimension; ++i) {
            int lower = this.index[i];
            int upper = this.index[dimension + i];
            if (lower <= upper) continue;
            throw new IllegalArgumentException(MessageFormat.format("Illegal grid range [{1} .. {2}] for dimension {0}.", i, lower, upper - 1));
        }
    }

    private GeneralGridEnvelope(int dimension) {
        this.index = new int[dimension * 2];
    }

    public GeneralGridEnvelope(GridEnvelope envelope) {
        int dimension = envelope.getDimension();
        this.index = new int[dimension * 2];
        for (int i = 0; i < dimension; ++i) {
            this.index[i] = envelope.getLow(i);
            this.index[i + dimension] = envelope.getHigh(i) + 1;
        }
        this.checkCoherence();
    }

    public GeneralGridEnvelope(Rectangle rect, int dimension) {
        this(rect.x, rect.y, rect.width, rect.height, dimension);
    }

    public GeneralGridEnvelope(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height, 2);
    }

    public GeneralGridEnvelope(Raster raster, int dimension) {
        this(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), dimension);
    }

    public GeneralGridEnvelope(RenderedImage image, int dimension) {
        this(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight(), dimension);
    }

    private GeneralGridEnvelope(int x, int y, int width, int height, int dimension) {
        if (dimension < 2) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "dimension", dimension));
        }
        this.index = new int[dimension * 2];
        this.index[0] = x;
        this.index[1] = y;
        this.index[dimension + 0] = x + width;
        this.index[dimension + 1] = y + height;
        Arrays.fill(this.index, dimension + 2, this.index.length, 1);
        this.checkCoherence();
    }

    public GeneralGridEnvelope(Bounds envelope, PixelInCell anchor) throws IllegalArgumentException {
        this(envelope, anchor, false);
    }

    public GeneralGridEnvelope(Bounds envelope, PixelInCell anchor, boolean isHighIncluded) throws IllegalArgumentException {
        int i;
        double offset = PixelTranslation.getPixelTranslation(anchor) + 0.5;
        int dimension = envelope.getDimension();
        this.index = new int[dimension * 2];
        for (i = 0; i < dimension; ++i) {
            this.index[i] = (int)Math.round(envelope.getMinimum(i) + offset);
            this.index[i + dimension] = (int)Math.round(envelope.getMaximum(i) + offset);
        }
        if (isHighIncluded) {
            i = this.index.length / 2;
            while (i < this.index.length) {
                int n = i++;
                this.index[n] = this.index[n] + 1;
            }
        }
        this.checkCoherence();
    }

    public GeneralGridEnvelope(int[] low, int[] high, boolean isHighIncluded) {
        if (low.length != high.length) {
            throw new IllegalArgumentException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", low.length, high.length));
        }
        this.index = new int[low.length + high.length];
        System.arraycopy(low, 0, this.index, 0, low.length);
        System.arraycopy(high, 0, this.index, low.length, high.length);
        if (isHighIncluded) {
            int i = low.length;
            while (i < this.index.length) {
                int n = i++;
                this.index[n] = this.index[n] + 1;
            }
        }
        this.checkCoherence();
    }

    public GeneralGridEnvelope(int[] low, int[] high) {
        this(low, high, false);
    }

    @Override
    public int getDimension() {
        return this.index.length / 2;
    }

    @Override
    public GridCoordinates getLow() {
        if (this.low == null) {
            this.low = new GeneralGridCoordinates.Immutable(this.index, 0, this.index.length / 2);
        }
        return this.low;
    }

    @Override
    public GridCoordinates getHigh() {
        if (this.high == null) {
            GeneralGridCoordinates.Immutable coords = new GeneralGridCoordinates.Immutable(this.index, this.index.length / 2, this.index.length);
            coords.translate(-1);
            this.high = coords;
        }
        return this.high;
    }

    @Override
    public int getLow(int dimension) {
        if (dimension < this.index.length / 2) {
            return this.index[dimension];
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    @Override
    public int getHigh(int dimension) {
        if (dimension >= 0) {
            return this.index[dimension + this.index.length / 2] - 1;
        }
        throw new ArrayIndexOutOfBoundsException(dimension);
    }

    @Override
    public int getSpan(int dimension) {
        return this.index[dimension + this.index.length / 2] - this.index[dimension];
    }

    public GeneralGridEnvelope getSubGridEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.index.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "lower", lower));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "upper", upper));
        }
        GeneralGridEnvelope sub = new GeneralGridEnvelope(newDim);
        System.arraycopy(this.index, lower, sub.index, 0, newDim);
        System.arraycopy(this.index, lower + curDim, sub.index, newDim, newDim);
        return sub;
    }

    public Rectangle toRectangle() throws IllegalStateException {
        if (this.index.length == 4) {
            return new Rectangle(this.index[0], this.index[1], this.index[2] - this.index[0], this.index[3] - this.index[1]);
        }
        Integer arg0 = this.getDimension();
        throw new IllegalStateException(MessageFormat.format("Can't wrap a {0} dimensional object into a 2 dimensional one.", arg0));
    }

    public int hashCode() {
        int code = -25078176;
        if (this.index != null) {
            int i = this.index.length;
            while (--i >= 0) {
                code = code * 31 + this.index[i];
            }
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof GeneralGridEnvelope) {
            GeneralGridEnvelope that = (GeneralGridEnvelope)object;
            return Arrays.equals(this.index, that.index);
        }
        return false;
    }

    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    static String toString(GridEnvelope envelope) {
        int dimension = envelope.getDimension();
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(envelope));
        buffer.append('[');
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(envelope.getLow(i)).append("..").append(envelope.getHigh(i));
        }
        return buffer.append(']').toString();
    }
}

