/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import io.airlift.compress.zstd.ZstdDecompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.PredictorDecompressor;
import java.io.IOException;

public class TIFFZSTDDecompressor
extends TIFFDecompressor {
    private final int predictor;
    ZstdDecompressor zstdDecompressor = new ZstdDecompressor();

    public TIFFZSTDDecompressor(int predictor) {
        this.predictor = predictor;
    }

    @Override
    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        PredictorDecompressor predictorDecompressor = new PredictorDecompressor(this.predictor, this.bitsPerSample, this.sampleFormat, this.samplesPerPixel, this.stream.getByteOrder());
        predictorDecompressor.validate();
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.zstdDecompressor.decompress(srcData, 0, this.byteCount, buf, bufOffset, bytesPerRow * this.srcHeight);
        predictorDecompressor.decompress(buf, bufOffset, dstOffset, this.srcHeight, this.srcWidth, bytesPerRow);
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }
}

