/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.compression.CompressionFinder;
import it.geosolutions.imageio.compression.CompressionType;
import it.geosolutions.imageio.compression.Compressor;
import it.geosolutions.imageio.plugins.tiff.TIFFCompressor;
import java.io.IOException;
import javax.imageio.ImageWriteParam;

public class TIFFDeflater
extends TIFFCompressor {
    Compressor deflateCompressor;
    int predictor;

    public TIFFDeflater(String compressionType, int compressionTagValue, ImageWriteParam param, int predictorValue) {
        super(compressionType, compressionTagValue, true);
        int deflateLevel;
        this.predictor = predictorValue;
        if (param != null && param.getCompressionMode() == 2) {
            float quality = param.getCompressionQuality();
            deflateLevel = (int)(1.0f + 8.0f * quality);
        } else {
            deflateLevel = -1;
        }
        this.deflateCompressor = CompressionFinder.getCompressor(deflateLevel, CompressionType.DEFLATE);
    }

    @Override
    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int inputSize = height * scanlineStride;
        int blocks = (inputSize + Short.MAX_VALUE) / 32768;
        byte[] compData = new byte[inputSize + 5 * blocks + 6];
        int numCompressedBytes = 0;
        if (this.predictor == 2) {
            int samplesPerPixel = bitsPerSample.length;
            int bitsPerPixel = 0;
            for (int i = 0; i < samplesPerPixel; ++i) {
                bitsPerPixel += bitsPerSample[i];
            }
            int bytesPerRow = (bitsPerPixel * width + 7) / 8;
            byte[] rowBuf = new byte[bytesPerRow];
            int maxRow = height - 1;
            for (int i = 0; i < height; ++i) {
                System.arraycopy(b, off, rowBuf, 0, bytesPerRow);
                for (int j = bytesPerRow - 1; j >= samplesPerPixel; --j) {
                    int n = j;
                    rowBuf[n] = (byte)(rowBuf[n] - rowBuf[j - samplesPerPixel]);
                }
                int numBytes = 0;
                this.deflateCompressor.setInput(rowBuf);
                if (i == maxRow) {
                    this.deflateCompressor.finish();
                }
                while ((numBytes = this.deflateCompressor.compress(compData, 0, rowBuf.length, numCompressedBytes, compData.length - numCompressedBytes)) != 0) {
                    numCompressedBytes += numBytes;
                }
                off += scanlineStride;
            }
        } else {
            this.deflateCompressor.setInput(b);
            this.deflateCompressor.finish();
            numCompressedBytes = this.deflateCompressor.compress(compData, off, height * scanlineStride, 0, compData.length);
        }
        this.stream.write(compData, 0, numCompressedBytes);
        return numCompressedBytes;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.deflateCompressor.done();
        this.deflateCompressor = null;
    }
}

