/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.compression;

import it.geosolutions.imageio.compression.CompressionPrioritySpi;
import it.geosolutions.imageio.compression.CompressorSpi;
import it.geosolutions.imageio.compression.DecompressorSpi;
import it.geosolutions.imageio.registry.ImageIOEXTRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class CompressionRegistry
extends ImageIOEXTRegistry {
    private static final List<Class<?>> INITIAL_TYPES = new ArrayList(2);
    private static final CompressionRegistry DEFAULT_INSTANCE;

    public CompressionRegistry() {
        super(INITIAL_TYPES.iterator());
        this.registerApplicationClasspathSpis();
    }

    public static CompressionRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public void registerApplicationClasspathSpis() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator<Class<?>> categories = this.getSubTypes();
        while (categories.hasNext()) {
            Class<?> _class = categories.next();
            Iterator<?> iterator = ServiceLoader.load(_class, cl).iterator();
            while (iterator.hasNext()) {
                try {
                    CompressionPrioritySpi spi = (CompressionPrioritySpi)iterator.next();
                    this.registerSPI(spi);
                }
                catch (ServiceConfigurationError sce) {
                    if (System.getSecurityManager() != null) continue;
                    throw sce;
                }
            }
        }
    }

    static {
        INITIAL_TYPES.add(CompressorSpi.class);
        INITIAL_TYPES.add(DecompressorSpi.class);
        DEFAULT_INSTANCE = new CompressionRegistry();
    }
}

