/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.customizepublictransportstop;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.IWaySegment;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.customizepublictransportstop.NearestWaySegment;
import org.openstreetmap.josm.plugins.customizepublictransportstop.StopArea;
import org.openstreetmap.josm.plugins.customizepublictransportstop.StopAreaOperationBase;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;

public class CreateNewStopPointOperation
extends StopAreaOperationBase {
    public CreateNewStopPointOperation(DataSet currentDataSet) {
        super(currentDataSet);
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point p) {
        TreeMap<Double, List<Node>> nearestMap = new TreeMap<Double, List<Node>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = 200.0;
            snapDistanceSq *= snapDistanceSq;
            for (Node n : ds.searchNodes(this.getBBox(p, 200))) {
                List<Object> nlist;
                double d;
                double dist = MainApplication.getMap().mapView.getPoint2D(n).distanceSq(p);
                if (!(d < snapDistanceSq)) continue;
                if (nearestMap.containsKey(dist)) {
                    nlist = nearestMap.get(dist);
                } else {
                    nlist = new LinkedList();
                    nearestMap.put(dist, nlist);
                }
                nlist.add(n);
            }
        }
        return nearestMap;
    }

    private BBox getBBox(Point p, int snapDistance) {
        MapView mapView = MainApplication.getMap().mapView;
        return new BBox(mapView.getLatLon(p.x - snapDistance, p.y - snapDistance), mapView.getLatLon(p.x + snapDistance, p.y + snapDistance));
    }

    public AbstractMap.SimpleEntry<Double, Node> getNearestNode(LatLon platformCoord, StopArea stopArea) {
        Point p = MainApplication.getMap().mapView.getPoint(platformCoord);
        Map<Double, List<Node>> dist_nodes = this.getNearestNodesImpl(p);
        Double[] distances = dist_nodes.keySet().toArray(new Double[0]);
        distances = this.sort(distances);
        Integer distanceIndex = -1;
        Node nearestNode = null;
        block0: while ((distanceIndex = Integer.valueOf(distanceIndex + 1)) < distances.length && nearestNode == null) {
            List<Node> nodes = dist_nodes.get(distances[distanceIndex]);
            for (Node node : nodes) {
                for (Way way : this.getCurrentDataSet().getWays()) {
                    if (!way.getNodes().contains(node) || !this.testWay(way, stopArea).booleanValue()) continue;
                    nearestNode = node;
                    return new AbstractMap.SimpleEntry<Double, Node>(distances[distanceIndex], nearestNode);
                }
                if (nearestNode == null) continue;
                continue block0;
            }
        }
        return null;
    }

    public Double[] sort(Double[] distances) {
        Integer i = 0;
        while (i < distances.length - 1) {
            Integer n;
            Integer j = i + 1;
            while (j < distances.length) {
                if (distances[i] > distances[j]) {
                    Double d = distances[i];
                    distances[i.intValue()] = distances[j];
                    distances[j.intValue()] = d;
                }
                n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
            Integer n3 = i;
            n = i = Integer.valueOf(i + 1);
        }
        return distances;
    }

    public Boolean testWay(Way way, StopArea stopArea) {
        String highway;
        if (stopArea.isTrainStation.booleanValue() || stopArea.isTrainStop.booleanValue()) {
            if ("rail".equals(way.getKeys().get((Object)"railway")) && "main".equals(way.getKeys().get((Object)"usage"))) {
                return true;
            }
            return false;
        }
        if (stopArea.isTram.booleanValue()) {
            if ("tram".equals(way.getKeys().get((Object)"railway"))) {
                return true;
            }
            return false;
        }
        String[] highwayValues = new String[]{"trunk", "primary", "secondary", "tertiary", "unclassified", "residential", "service", "bus_guideway", "road", "trunk_link", "primary_link", "secondary_link", "tertiary_link"};
        if ((stopArea.isBus.booleanValue() || stopArea.isTrolleybus.booleanValue() || stopArea.isShareTaxi.booleanValue()) && (highway = way.getKeys().get((Object)"highway")) != null) {
            Integer i = 0;
            while (i < highwayValues.length) {
                if (highwayValues[i].equals(highway)) {
                    return true;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return false;
    }

    private Map<Double, List<IWaySegment<Node, Way>>> getNearestWaySegmentsImpl(Point p) {
        TreeMap<Double, List<IWaySegment<Node, Way>>> nearestMap = new TreeMap<Double, List<IWaySegment<Node, Way>>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = Config.getPref().getInt("mappaint.segment.snap-distance", 200);
            snapDistanceSq *= snapDistanceSq;
            for (Way w : ds.searchWays(this.getBBox(p, Config.getPref().getInt("mappaint.segment.snap-distance", 200)))) {
                Node lastN = null;
                int i = -2;
                for (Node n : w.getNodes()) {
                    double b;
                    ++i;
                    if (n.isDeleted() || n.isIncomplete()) continue;
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    Point2D A = MainApplication.getMap().mapView.getPoint2D(lastN);
                    Point2D B = MainApplication.getMap().mapView.getPoint2D(n);
                    double c = A.distanceSq(B);
                    double a = p.distanceSq(B);
                    double perDistSq = Double.longBitsToDouble(Double.doubleToLongBits(a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c) >> 32 << 32);
                    if (perDistSq < snapDistanceSq && a < c + snapDistanceSq && b < c + snapDistanceSq) {
                        List<IWaySegment> wslist;
                        if (nearestMap.containsKey(perDistSq)) {
                            wslist = (List)nearestMap.get(perDistSq);
                        } else {
                            wslist = new LinkedList();
                            nearestMap.put(perDistSq, wslist);
                        }
                        wslist.add(new IWaySegment((IWay)w, i));
                    }
                    lastN = n;
                }
            }
        }
        return nearestMap;
    }

    protected NearestWaySegment getNearestWaySegment(LatLon platformCoord, StopArea stopArea) {
        MapView mapView = MainApplication.getMap().mapView;
        Point p = mapView.getPoint(platformCoord);
        Map<Double, List<IWaySegment<Node, Way>>> dist_waySegments = this.getNearestWaySegmentsImpl(p);
        for (Map.Entry<Double, List<IWaySegment<Node, Way>>> entry : dist_waySegments.entrySet()) {
            for (IWaySegment<Node, Way> waySegment : entry.getValue()) {
                if (!this.testWay((Way)waySegment.getWay(), stopArea).booleanValue()) continue;
                Node n = (Node)waySegment.getFirstNode();
                Node lastN = (Node)waySegment.getSecondNode();
                EastNorth newPosition = Geometry.closestPointToSegment((EastNorth)n.getEastNorth(), (EastNorth)lastN.getEastNorth(), (EastNorth)ProjectionRegistry.getProjection().latlon2eastNorth(platformCoord));
                LatLon newNodePosition = ProjectionRegistry.getProjection().eastNorth2latlon(newPosition);
                Point2D lastN2D = mapView.getPoint2D(lastN);
                Point2D n2D = mapView.getPoint2D(n);
                Point2D newNodePosition2D = mapView.getPoint2D(newNodePosition);
                Double distCurrenNodes = lastN2D.distance(n2D);
                if (!(newNodePosition2D.distance(lastN2D) < distCurrenNodes) || !(newNodePosition2D.distance(n2D) < distCurrenNodes)) continue;
                return new NearestWaySegment(entry.getKey(), waySegment, new Node(newNodePosition));
            }
        }
        return null;
    }

    protected Node createNodeOnWay(Node newStopNode, IWaySegment<Node, Way> waySegment) {
        UndoRedoHandler.getInstance().add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newStopNode));
        List wayNodes = ((Way)waySegment.getWay()).getNodes();
        wayNodes.add(waySegment.getUpperIndex(), newStopNode);
        Way newWay = new Way((Way)waySegment.getWay());
        newWay.setNodes(wayNodes);
        UndoRedoHandler.getInstance().add((Command)new ChangeCommand((OsmPrimitive)waySegment.getWay(), (OsmPrimitive)newWay));
        return newStopNode;
    }

    @Override
    public StopArea performCustomizing(StopArea stopArea) {
        LatLon platformCoord = null;
        platformCoord = stopArea.selectedObject instanceof Node ? ((Node)stopArea.selectedObject).getCoor() : CreateNewStopPointOperation.getCenterOfWay(stopArea.selectedObject);
        if (platformCoord == null) {
            return stopArea;
        }
        AbstractMap.SimpleEntry<Double, Node> nearestNode = this.getNearestNode(platformCoord, stopArea);
        NearestWaySegment nearestWaySegment = this.getNearestWaySegment(platformCoord, stopArea);
        Node newStopPointNode = null;
        if (nearestNode != null && nearestWaySegment != null) {
            MapView mapView = MainApplication.getMap().mapView;
            Double segmentDist = mapView.getPoint2D(platformCoord).distanceSq(mapView.getPoint2D(nearestWaySegment.newNode));
            Double nodeDistSq = nearestNode.getKey();
            newStopPointNode = segmentDist < nodeDistSq - 2.0 ? this.createNodeOnWay(nearestWaySegment.newNode, nearestWaySegment.waySegment) : nearestNode.getValue();
        } else if (nearestNode != null && nearestWaySegment == null) {
            newStopPointNode = nearestNode.getValue();
        } else if (nearestNode == null && nearestWaySegment != null) {
            newStopPointNode = this.createNodeOnWay(nearestWaySegment.newNode, nearestWaySegment.waySegment);
        }
        if (newStopPointNode != null) {
            stopArea.stopPoints.add(newStopPointNode);
        }
        return stopArea;
    }
}

