/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class RemoveRouteNodeAction
extends MapMode {
    private static final int REMOVE_SQR_RADIUS = 100;

    public RemoveRouteNodeAction() {
        super(I18n.tr((String)"Routing", (Object[])new Object[0]), "remove", I18n.tr((String)"Click to remove destination", (Object[])new Object[0]), ImageProvider.getCursor((String)"normal", (String)"delete"));
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
            RoutingModel routingModel = layer.getRoutingModel();
            List<Node> nl = routingModel.getSelectedNodes();
            int index = -1;
            double dmax = 100.0;
            for (int i = 0; i < nl.size(); ++i) {
                Node node = nl.get(i);
                double d = MainApplication.getMap().mapView.getPoint(node).distanceSq(e.getPoint());
                if (!(d < dmax)) continue;
                dmax = d;
                index = i;
            }
            if (index >= 0) {
                Logging.trace((String)"Removing node {0}", (Object[])new Object[]{nl.get(index)});
                routingModel.removeNode(index);
                RoutingPlugin.getInstance().getRoutingDialog().removeNode(index);
                MainApplication.getLayerManager().getLayersOfType(RoutingLayer.class).forEach(AbstractMapViewPaintable::invalidate);
            } else {
                Logging.trace((String)"Can't find a node to remove.");
            }
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof RoutingLayer;
    }
}

