/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.eventbus;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.eventbus.DeadEvent;
import org.openstreetmap.josm.eventbus.Dispatcher;
import org.openstreetmap.josm.eventbus.Subscriber;
import org.openstreetmap.josm.eventbus.SubscriberExceptionContext;
import org.openstreetmap.josm.eventbus.SubscriberExceptionHandler;
import org.openstreetmap.josm.eventbus.SubscriberRegistry;

public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this(identifier, DirectExecutor.INSTANCE, Dispatcher.perThreadDispatchQueue(), LoggingHandler.INSTANCE);
    }

    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this("default", DirectExecutor.INSTANCE, Dispatcher.perThreadDispatchQueue(), exceptionHandler);
    }

    EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        this.identifier = Objects.requireNonNull(identifier);
        this.executor = Objects.requireNonNull(executor);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        Objects.requireNonNull(e);
        Objects.requireNonNull(context);
        try {
            this.exceptionHandler.handleException(e, context);
        }
        catch (Throwable e2) {
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "Exception %s thrown while handling exception: %s", e2, e), e2);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    public String toString() {
        return "EventBus [" + this.identifier + "]";
    }

    static final class LoggingHandler
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();

        LoggingHandler() {
        }

        @Override
        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            Logger logger = LoggingHandler.logger(context);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, LoggingHandler.message(context), exception);
            }
        }

        private static Logger logger(SubscriberExceptionContext context) {
            return Logger.getLogger(EventBus.class.getName() + "." + context.getEventBus().identifier());
        }

        private static String message(SubscriberExceptionContext context) {
            Method method = context.getSubscriberMethod();
            return "Exception thrown by subscriber method " + method.getName() + "(" + method.getParameterTypes()[0].getName() + ") on subscriber " + context.getSubscriber() + " when dispatching event: " + context.getEvent();
        }
    }

    static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

