/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.parts;

import com.bric.colorpicker.colorslider.Painter;
import com.bric.colorpicker.contextualmenu.ContextualMenuHelper;
import com.bric.colorpicker.listeners.ColorListener;
import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.parts.ImageTransferable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class ColorSwatch
extends JPanel
implements ColorListener {
    private static final String PROPERTY_COPY_CONTEXTUAL_MENU_ITEM = ColorSwatch.class + ".copyContextualMenuItem";
    private static final String LOCALIZATION_BUNDLE_PATH = "com.bric.colorpicker.resources.ColorPicker";
    private static TexturePaint checkerPaint;
    private final ResourceBundle strings;
    private final int w;

    public ColorSwatch(int width) {
        this(width, null);
    }

    private ColorSwatch(Color color, int width) {
        this(width);
        this.setForeground(color);
    }

    private ColorSwatch(Color color, int width, Locale locale) {
        this(width, locale);
        this.setForeground(color);
    }

    public ColorSwatch(int width, Locale locale) {
        this.strings = locale == null ? ResourceBundle.getBundle(LOCALIZATION_BUNDLE_PATH) : ResourceBundle.getBundle(LOCALIZATION_BUNDLE_PATH, locale);
        this.w = width;
        this.setPreferredSize(new Dimension(width, width));
        this.setMinimumSize(new Dimension(width, width));
        PropertyChangeListener pcl = evt -> this.updateContextualMenu();
        this.addPropertyChangeListener(PROPERTY_COPY_CONTEXTUAL_MENU_ITEM, pcl);
        this.updateContextualMenu();
    }

    private static TexturePaint getCheckerPaint() {
        if (checkerPaint == null) {
            int t = 8;
            BufferedImage bi = new BufferedImage(t * 2, t * 2, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, 2 * t, 2 * t);
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, t, t);
            g.fillRect(t, t, t, t);
            checkerPaint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
        }
        return checkerPaint;
    }

    private void updateContextualMenu() {
        ContextualMenuHelper.clear(this);
        if (Boolean.TRUE.equals(this.getClientProperty(PROPERTY_COPY_CONTEXTUAL_MENU_ITEM))) {
            String menuItemName = this.strings.getObject("Copy").toString();
            Runnable runnable = () -> {
                BufferedImage image = new BufferedImage(100, 100, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.dispose();
                ImageTransferable contents = new ImageTransferable(image);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
            };
            ContextualMenuHelper.add(this, menuItemName, runnable);
        }
    }

    @Override
    public void paint(Graphics g0) {
        super.paint(g0);
        Graphics2D g = (Graphics2D)g0;
        Color c = this.getForeground();
        int w2 = Math.min(this.getWidth(), this.w);
        int h2 = Math.min(this.getHeight(), this.w);
        Rectangle r = new Rectangle(this.getWidth() / 2 - w2 / 2, this.getHeight() / 2 - h2 / 2, w2, h2);
        if (c.getAlpha() < 255) {
            TexturePaint checkers = ColorSwatch.getCheckerPaint();
            g.setPaint(checkers);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, r.height);
        Painter painter = new Painter();
        painter.setGraphics2D(g);
        painter.drawBevel(r);
    }

    @Override
    public void colorChanged(ColorModel colorModel) {
        this.setForeground(colorModel.getColor());
    }
}

