/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import nanolog.Correlator;
import nanolog.GPXChooser;
import nanolog.NanoLogEntry;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class NanoLogLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer {
    private List<NanoLogEntry> log;
    private int selectedEntry;
    private final Set<NanoLogLayerListener> listeners = new HashSet<NanoLogLayerListener>();
    private NLLMouseAdapter mouseListener;

    public NanoLogLayer(List<NanoLogEntry> entries) {
        super(I18n.tr((String)"NanoLog", (Object[])new Object[0]));
        this.log = new ArrayList<NanoLogEntry>(entries);
        this.selectedEntry = -1;
        this.mouseListener = new NLLMouseAdapter();
    }

    public void setupListeners() {
        MainApplication.getMap().mapView.addMouseListener((MouseListener)this.mouseListener);
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)this.mouseListener);
    }

    public synchronized void destroy() {
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)this.mouseListener);
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)this.mouseListener);
        super.destroy();
    }

    public NanoLogLayer(File file) throws IOException {
        this(NanoLogLayer.readNanoLog(file));
    }

    public void addListener(NanoLogLayerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NanoLogLayerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMarkersChanged() {
        for (NanoLogLayerListener listener : this.listeners) {
            listener.markersUpdated(this);
        }
    }

    protected void fireMarkerSelected() {
        for (NanoLogLayerListener listener : this.listeners) {
            listener.markerActivated(this, this.selectedEntry < 0 ? null : this.log.get(this.selectedEntry));
        }
    }

    public List<NanoLogEntry> getEntries() {
        return Collections.unmodifiableList(this.log);
    }

    public static List<NanoLogEntry> readNanoLog(File file) throws IOException {
        Pattern NANOLOG_LINE = Pattern.compile("(.+?)\\t(.+?)(?:\\s*\\{\\{(-?\\d+\\.\\d+),\\s*(-?\\d+\\.\\d+)(?:,\\s*(\\d+))?\\}\\})?");
        SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SS");
        ArrayList<NanoLogEntry> result = new ArrayList<NanoLogEntry>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
            while (r.ready()) {
                Matcher m;
                String line = r.readLine();
                if (line == null || !(m = NANOLOG_LINE.matcher(line)).matches()) continue;
                String time = m.group(1);
                String message = m.group(2);
                String lat = m.group(3);
                String lon = m.group(4);
                String dir = m.group(5);
                Date timeDate = null;
                try {
                    timeDate = fmt.parse(time);
                }
                catch (ParseException e) {
                    Logging.warn((Throwable)e);
                }
                if (message == null || message.length() == 0 || timeDate == null) continue;
                LatLon pos = null;
                Integer direction = null;
                if (lat != null && lon != null) {
                    try {
                        pos = new LatLon(Double.parseDouble(lat), Double.parseDouble(lon));
                        direction = Integer.valueOf(dir);
                    }
                    catch (NumberFormatException e) {
                        Logging.trace((Throwable)e);
                    }
                }
                result.add(new NanoLogEntry(timeDate, message, pos, direction));
            }
        }
        return result;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        for (int i = 0; i < this.log.size(); ++i) {
            NanoLogEntry entry = this.log.get(i);
            int radius = 4;
            if (entry.getPos() == null) continue;
            Point p = mv.getPoint(entry.getPos());
            g.setColor(this.selectedEntry == i ? Color.red : Color.yellow);
            g.fillOval(p.x - radius, p.y - radius, radius * 2, radius * 2);
        }
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"nanolog.png");
    }

    public String getToolTipText() {
        return I18n.tr((String)"NanoLog of {0} entries", (Object[])new Object[]{this.log.size()});
    }

    public void mergeFrom(Layer from) {
    }

    public boolean isMergable(Layer other) {
        return other instanceof NanoLogLayer;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (NanoLogEntry entry : this.log) {
            v.visit(entry.getPos());
        }
    }

    public Object getInfoComponent() {
        StringBuilder b = new StringBuilder();
        int cnt = 0;
        for (NanoLogEntry e : this.log) {
            if (e.getPos() == null) continue;
            ++cnt;
        }
        b.append(I18n.tr((String)"NanoLog of {0} lines, {1} of them with coordinates.", (Object[])new Object[]{this.log.size(), cnt}));
        return b.toString();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new CorrelateEntries(true), new CorrelateEntries(false), new SaveLayer(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void jumpToNextMarker() {
        ++this.selectedEntry;
        if (this.selectedEntry < 0) {
            this.selectedEntry = 0;
        } else if (this.selectedEntry >= this.log.size()) {
            this.selectedEntry = this.log.size() - 1;
        }
        this.invalidate();
    }

    public void jumpToPreviousMarker() {
        --this.selectedEntry;
        if (this.selectedEntry < 0) {
            this.selectedEntry = 0;
        } else if (this.selectedEntry >= this.log.size()) {
            this.selectedEntry = this.log.size() - 1;
        }
        this.invalidate();
    }

    protected void setSelected(int i) {
        int newSelected;
        int n = newSelected = i >= 0 && i < this.log.size() ? i : -1;
        if (newSelected != this.selectedEntry) {
            this.selectedEntry = newSelected;
            this.fireMarkerSelected();
            this.invalidate();
        }
    }

    public void setSelected(NanoLogEntry entry) {
        if (entry == null) {
            this.setSelected(-1);
        } else {
            for (int i = 0; i < this.log.size(); ++i) {
                if (!entry.equals(this.log.get(i))) continue;
                this.setSelected(i);
                break;
            }
        }
    }

    protected void dragTo(int entry, int x, int y) {
        double tolerance;
        GpxLayer gpx = GPXChooser.topLayer();
        if (gpx == null) {
            return;
        }
        EastNorth eastNorth = MainApplication.getMap().mapView.getEastNorth(x, y);
        WayPoint wp = gpx.data.nearestPointOnTrack(eastNorth, tolerance = eastNorth.distance(MainApplication.getMap().mapView.getEastNorth(x + 300, y)));
        if (wp == null) {
            return;
        }
        long newTime = Correlator.getGpxDate(gpx.data, wp.getCoor());
        if (newTime <= 0L) {
            return;
        }
        Correlator.revertPos(this.log);
        Correlator.correlate(this.log, gpx.data, this.log.get(entry).getTime().getTime() - newTime);
        MainApplication.getMap().mapView.repaint();
    }

    public static interface NanoLogLayerListener {
        public void markersUpdated(NanoLogLayer var1);

        public void markerActivated(NanoLogLayer var1, NanoLogEntry var2);
    }

    private static class SaveLayer
    extends JosmAction {
        SaveLayer() {
            super(I18n.tr((String)"Save layer...", (Object[])new Object[0]), "nanolog/save", I18n.tr((String)"Save NanoLog layer", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), "Sorry, no saving yet", "NanoLog", 0);
        }
    }

    private class CorrelateEntries
    extends JosmAction {
        private boolean toZero;

        CorrelateEntries(boolean toZero) {
            super(toZero ? I18n.tr((String)"Correlate with GPX...", (Object[])new Object[0]) : I18n.tr((String)"Put on GPX...", (Object[])new Object[0]), "nanolog/correlate", I18n.tr((String)"Correlate entries with GPS trace", (Object[])new Object[0]), null, false);
            this.toZero = toZero;
        }

        public void actionPerformed(ActionEvent e) {
            GpxLayer layer = GPXChooser.chooseLayer();
            if (layer != null) {
                long offset = this.toZero ? 0L : Correlator.crudeMatch(NanoLogLayer.this.log, layer.data);
                Correlator.revertPos(NanoLogLayer.this.log);
                Correlator.correlate(NanoLogLayer.this.log, layer.data, offset);
                NanoLogLayer.this.fireMarkersChanged();
                MainApplication.getMap().mapView.repaint();
            }
        }
    }

    private class NLLMouseAdapter
    extends MouseAdapter {
        private int dragging;

        private NLLMouseAdapter() {
        }

        public int nearestEntry(MouseEvent e) {
            LatLon ll = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
            int radius = 8;
            if (ll != null) {
                LatLon lld = MainApplication.getMap().mapView.getLatLon(e.getX() + radius, e.getY() + radius);
                double distance = Math.max(lld.lat() - ll.lat(), lld.lon() - ll.lon());
                boolean selectedIsSelected = false;
                int newSelected = -1;
                for (int i = 0; i < NanoLogLayer.this.log.size(); ++i) {
                    if (NanoLogLayer.this.log.get(i).getPos() == null || !(NanoLogLayer.this.log.get(i).getPos().distance(ll) < distance)) continue;
                    newSelected = i;
                    if (i != NanoLogLayer.this.selectedEntry) continue;
                    selectedIsSelected = true;
                }
                if (newSelected >= 0) {
                    return selectedIsSelected ? NanoLogLayer.this.selectedEntry : newSelected;
                }
            }
            return -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int nearest = this.nearestEntry(e);
            if (nearest > 0) {
                NanoLogLayer.this.setSelected(nearest);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.doDrag(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragging > 0) {
                this.dragging = 0;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int nearest = this.nearestEntry(e);
            if (nearest > 0 && MainApplication.getLayerManager().getActiveLayer() == NanoLogLayer.this) {
                this.dragging = nearest;
                this.doDrag(e);
            }
        }

        private void doDrag(MouseEvent e) {
            if (this.dragging > 0) {
                NanoLogLayer.this.dragTo(this.dragging, e.getX(), e.getY());
            }
        }
    }
}

