/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.jrt.core;

import com.innovant.josm.jrt.core.RoutingGraphDelegator;
import com.innovant.josm.jrt.core.RoutingProfile;
import com.innovant.josm.jrt.osm.OsmEdge;
import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordShortestPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Logging;

public class RoutingGraph {
    private final RoutingProfile routingProfile;
    private RouteType routeType;
    private final DataSet data;
    private static final Collection<String> excludedHighwayValues = Arrays.asList("bus_stop", "traffic_signals", "street_lamp", "stop", "construction", "platform", "give_way", "proposed", "milestone", "speed_camera", "abandoned");
    private Graph<Node, OsmEdge> graph = null;
    private RoutingGraphDelegator rgDelegator;
    private Map<String, Double> waySpeeds;

    public Graph<Node, OsmEdge> getGraph() {
        return this.graph;
    }

    private void addEdgeBidirectional(Way way, Node from, Node to) {
        this.addEdge(way, from, to);
        this.addEdge(way, to, from);
    }

    private void addEdgeReverseOneway(Way way, Node from, Node to) {
        this.addEdge(way, to, from);
    }

    private void addEdgeNormalOneway(Way way, Node from, Node to) {
        this.addEdge(way, from, to);
    }

    public RoutingGraph(DataSet data) {
        this.data = data;
        this.routeType = RouteType.SHORTEST;
        this.routingProfile = new RoutingProfile("default");
        this.routingProfile.setOnewayUse(true);
        this.setWaySpeeds(this.routingProfile.getWaySpeeds());
        Logging.trace((String)"Created RoutingGraph");
    }

    public void createGraph() {
        Logging.trace((String)"Creating Graph...");
        this.graph = new DirectedWeightedMultigraph<Node, OsmEdge>(OsmEdge.class);
        this.rgDelegator = new RoutingGraphDelegator(this.graph);
        this.rgDelegator.setRouteType(this.routeType);
        for (Way way : this.data.getWays()) {
            if (way == null || way.isDeleted() || !this.isvalidWay(way) || way.getNodesCount() == 0) continue;
            Node from = null;
            Node to = null;
            List nodes = way.getNodes();
            int nodesCount = nodes.size();
            String onewayVal = way.get("oneway");
            String junctionVal = way.get("junction");
            from = (Node)nodes.get(0);
            this.graph.addVertex(from);
            for (int i = 1; i < nodesCount; ++i) {
                to = (Node)nodes.get(i);
                if (to == null || to.isDeleted()) continue;
                this.graph.addVertex(to);
                if (!this.routingProfile.isOnewayUsed()) {
                    this.addEdgeBidirectional(way, from, to);
                } else if (onewayVal == null && "roundabout".equals(junctionVal)) {
                    this.addEdgeNormalOneway(way, from, to);
                } else if (onewayVal == null || Arrays.asList("false", "no", "0").contains(onewayVal)) {
                    this.addEdgeBidirectional(way, from, to);
                } else if ("-1".equals(onewayVal)) {
                    this.addEdgeReverseOneway(way, from, to);
                } else if (Arrays.asList("1", "yes", "true").contains(onewayVal)) {
                    this.addEdgeNormalOneway(way, from, to);
                }
                from = to;
            }
        }
        Logging.trace((String)"End Create Graph");
        Logging.trace((String)"Vertex: {0}", (Object[])new Object[]{this.graph.vertexSet().size()});
        Logging.trace((String)"Edges: {0}", (Object[])new Object[]{this.graph.edgeSet().size()});
    }

    private void addEdge(Way way, Node from, Node to) {
        if (!from.isLatLonKnown() || !to.isLatLonKnown()) {
            return;
        }
        OsmEdge edge = new OsmEdge(way, from, to);
        double length = edge.getLength();
        edge.setSpeed(12.1);
        this.graph.addEdge(from, to, edge);
        double weight = this.getWeight(way, length);
        this.setWeight(edge, length);
        Logging.trace((String)"edge for way {0} (from node {1} to node {2}) has weight: {3}", (Object[])new Object[]{way.getId(), from.getId(), to.getId(), weight});
        ((DirectedWeightedMultigraph)this.graph).setEdgeWeight(edge, weight);
    }

    private void setWeight(OsmEdge osmedge, double length) {
        osmedge.setLength(length);
        if (this.waySpeeds.containsKey(osmedge.getWay().get("highway"))) {
            osmedge.setSpeed(this.waySpeeds.get(osmedge.getWay().get("highway")));
        }
    }

    private double getWeight(Way way, double length) {
        double speed = 1.0;
        switch (this.routeType) {
            case SHORTEST: {
                if (!this.waySpeeds.containsKey("residential")) break;
                speed = this.waySpeeds.get("residential");
                break;
            }
            case FASTEST: {
                if (this.waySpeeds.containsKey(way.get("highway"))) {
                    speed = this.waySpeeds.get(way.get("highway"));
                }
                Logging.trace((String)"Speed={0}", (Object[])new Object[]{speed});
                break;
            }
        }
        return length / speed;
    }

    public boolean isvalidWay(Way way) {
        String highway = way.get("highway");
        return highway != null && !excludedHighwayValues.contains(highway) || way.get("junction") != null || way.get("service") != null;
    }

    public List<OsmEdge> applyAlgorithm(List<Node> nodes, Algorithm algorithm) {
        List<OsmEdge> path = new ArrayList<OsmEdge>();
        double totalWeight = 0.0;
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        RoutingLayer layer = MainApplication.getLayerManager().getLayersOfType(RoutingLayer.class).stream().filter(arg_0 -> RoutingGraph.lambda$applyAlgorithm$0((Layer)editLayer, arg_0)).findFirst().orElse(null);
        if (layer == null) {
            return Collections.emptyList();
        }
        RoutingModel routingModel = layer.getRoutingModel();
        if (this.graph == null || routingModel.getOnewayChanged()) {
            this.createGraph();
        }
        Logging.trace((String)"apply algorithm between nodes ");
        for (Node node : nodes) {
            Logging.trace((String)Long.toString(node.getId()));
        }
        Logging.trace((String)"-----------------------------------");
        Graph<Node, OsmEdge> g = this.graph;
        block0 : switch (algorithm) {
            case ROUTING_ALG_DIJKSTRA: {
                Logging.trace((String)"Using Dijkstra algorithm");
                DijkstraShortestPath<Node, OsmEdge> routingk = null;
                for (int index = 1; index < nodes.size(); ++index) {
                    routingk = new DijkstraShortestPath<Node, OsmEdge>(g, nodes.get(index - 1), nodes.get(index));
                    if (routingk.getPathEdgeList() == null) {
                        Logging.trace((String)"no path found!");
                        break block0;
                    }
                    path.addAll(routingk.getPathEdgeList());
                    totalWeight += routingk.getPathLength();
                }
                break;
            }
            case ROUTING_ALG_BELLMANFORD: {
                Logging.trace((String)"Using Bellman Ford algorithm");
                for (int index = 1; index < nodes.size(); ++index) {
                    path = BellmanFordShortestPath.findPathBetween(this.rgDelegator, nodes.get(index - 1), nodes.get(index));
                    if (path != null && !path.isEmpty()) continue;
                    Logging.trace((String)"no path found!");
                    return Collections.emptyList();
                }
                break;
            }
            default: {
                Logging.trace((String)"Wrong algorithm");
            }
        }
        Logging.trace((String)"shortest path found: {0}\nweight: {1}", (Object[])new Object[]{path, totalWeight});
        return path;
    }

    public int getVertexCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.vertexSet().size();
        }
        return value;
    }

    public int getEdgeCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.edgeSet().size();
        }
        return value;
    }

    public void setTypeRoute(RouteType routeType) {
        this.routeType = routeType;
        this.rgDelegator.setRouteType(routeType);
    }

    public RouteType getTypeRoute() {
        return this.routeType;
    }

    public Map<String, Double> getWaySpeeds() {
        return this.waySpeeds;
    }

    public void setWaySpeeds(Map<String, Double> waySpeeds) {
        this.waySpeeds = waySpeeds;
    }

    public void resetGraph() {
        this.graph = null;
    }

    public RoutingProfile getRoutingProfile() {
        return this.routingProfile;
    }

    private static /* synthetic */ boolean lambda$applyAlgorithm$0(Layer editLayer, RoutingLayer rLayer) {
        return rLayer.getDataLayer() == editLayer;
    }

    public static enum RouteType {
        FASTEST,
        SHORTEST;

    }

    public static enum Algorithm {
        ROUTING_ALG_DIJKSTRA,
        ROUTING_ALG_BELLMANFORD;

    }
}

