/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo.ruian;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.logging.Level;
import org.apache.commons.jcs3.access.exception.InvalidArgumentException;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoUtils;
import org.openstreetmap.josm.plugins.pointinfo.ruian.AddrPlaces;
import org.openstreetmap.josm.plugins.pointinfo.ruian.ObjectWithoutGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

class RuianRecord {
    private double mCoorLat;
    private double mCoorLon;
    private String mSource;
    private long mObjektRuianId;
    private int mObjektPodlazi;
    private int mObjektByty;
    private String mObjektZpusobVyuziti;
    private String mObjektZpusobVyuzitiKod;
    private String mObjektZpusobVyuzitiKey;
    private String mObjektZpusobVyuzitiVal;
    private String mObjektDokonceni;
    private String mObjektPlatiOd;
    private String mErrUser;
    private String mErrDate;
    private String mErrType;
    private String mErrNote;
    private ArrayList<ObjectWithoutGeometry> mSoBezGeometrie;
    private ArrayList<AddrPlaces> mAdresniMista;
    private long mParcelaRuianId;
    private String mParcelaDruhPozemku;
    private String mParcelaZpusobVyuziti;
    private String mParcelaPlatiOd;
    private long mUliceRuianId;
    private String mUliceJmeno;
    private long mKatastrRuianId;
    private String mKatastrNazev;
    private long mKatastrObecKod;
    private String mKatastrObec;
    private long mKatastrOkresKod;
    private String mKatastrOkres;
    private long mKatastrKrajKod;
    private String mKatastrKraj;

    RuianRecord() {
        this.init();
    }

    private void init() {
        this.mCoorLat = 0.0;
        this.mCoorLon = 0.0;
        this.mSource = "";
        this.mObjektRuianId = 0L;
        this.mObjektPodlazi = 0;
        this.mObjektByty = 0;
        this.mObjektZpusobVyuziti = "";
        this.mObjektZpusobVyuzitiKod = "";
        this.mObjektZpusobVyuzitiKey = "";
        this.mObjektZpusobVyuzitiVal = "";
        this.mObjektDokonceni = "";
        this.mObjektPlatiOd = "";
        this.mErrUser = "";
        this.mErrDate = "";
        this.mErrType = "";
        this.mErrNote = "";
        this.mSoBezGeometrie = new ArrayList();
        this.mAdresniMista = new ArrayList();
        this.mParcelaRuianId = 0L;
        this.mParcelaDruhPozemku = "";
        this.mParcelaZpusobVyuziti = "";
        this.mParcelaPlatiOd = "";
        this.mUliceRuianId = 0L;
        this.mUliceJmeno = "";
        this.mKatastrRuianId = 0L;
        this.mKatastrNazev = "";
        this.mKatastrObecKod = 0L;
        this.mKatastrObec = "";
        this.mKatastrOkresKod = 0L;
        this.mKatastrOkres = "";
        this.mKatastrKrajKod = 0L;
        this.mKatastrKraj = "";
    }

    public void parseJSON(String jsonStr) {
        this.init();
        JsonReader jsonReader = Json.createReader((InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        this.parseCoordinates(obj);
        this.parseStavebniObjekt(obj);
        this.parseNahlasenyProblem(obj);
        this.parseSoBezGeometrie(obj);
        this.parseAdresniMista(obj);
        this.parseParcela(obj);
        this.parseUlice(obj);
        this.parseKatastr(obj);
    }

    private static JsonObject getSafeJsonObject(JsonObject obj, String key) {
        JsonArray array;
        JsonValue val = (JsonValue)obj.get((Object)key);
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        if (val instanceof JsonArray && !(array = (JsonArray)val).isEmpty()) {
            return array.getJsonObject(0);
        }
        throw new IllegalArgumentException("No value for " + key);
    }

    private void parseCoordinates(JsonObject obj) {
        try {
            JsonObject coorObjekt = obj.getJsonObject("coordinates");
            try {
                this.mCoorLat = Double.parseDouble(coorObjekt.getString("lat"));
            }
            catch (NumberFormatException e) {
                Logging.warn((String)"coordinates.lat: {0}", (Object[])new Object[]{e});
            }
            try {
                this.mCoorLon = Double.parseDouble(coorObjekt.getString("lon"));
            }
            catch (NumberFormatException e) {
                Logging.warn((String)"coordinates.lon: {0}", (Object[])new Object[]{e});
            }
            try {
                this.mSource = obj.getString("source");
            }
            catch (RuntimeException e) {
                Logging.warn((String)"source: {0}", (Object[])new Object[]{e});
            }
        }
        catch (ClassCastException e) {
            Logging.warn((String)"coordinates: {0}", (Object[])new Object[]{e});
        }
    }

    private void parseStavebniObjekt(JsonObject obj) {
        try {
            JsonObject stavebniObjekt = RuianRecord.getSafeJsonObject(obj, "stavebni_objekt");
            try {
                this.mObjektRuianId = Long.parseLong(stavebniObjekt.getString("ruian_id", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.ruian_id:", (Throwable)e);
            }
            try {
                this.mObjektPodlazi = Integer.parseInt(stavebniObjekt.getString("pocet_podlazi", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.pocet_podlazi:", (Throwable)e);
            }
            try {
                this.mObjektByty = Integer.parseInt(stavebniObjekt.getString("pocet_bytu", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"stavebni_objekt.pocet_bytu:", (Throwable)e);
            }
            this.mObjektZpusobVyuziti = stavebniObjekt.getString("zpusob_vyuziti", "");
            this.mObjektZpusobVyuzitiKod = stavebniObjekt.getString("zpusob_vyuziti_kod", "");
            this.mObjektZpusobVyuzitiKey = stavebniObjekt.getString("zpusob_vyuziti_key", "");
            this.mObjektZpusobVyuzitiVal = stavebniObjekt.getString("zpusob_vyuziti_val", "");
            this.mObjektPlatiOd = stavebniObjekt.getString("plati_od", "");
            this.mObjektDokonceni = stavebniObjekt.getString("dokonceni", "");
        }
        catch (IllegalArgumentException e) {
            Logging.warn((String)"stavebni_objekt: {0}", (Object[])new Object[]{e});
        }
    }

    private void parseNahlasenyProblem(JsonObject obj) {
        try {
            JsonObject errObjekt = RuianRecord.getSafeJsonObject(obj, "nahlaseny_problem");
            this.mErrUser = errObjekt.getString("uzivatel", "");
            this.mErrDate = errObjekt.getString("datum", "");
            this.mErrType = errObjekt.getString("duvod", "");
            this.mErrNote = errObjekt.getString("poznamka", "");
        }
        catch (IllegalArgumentException e) {
            Logging.warn((String)"nahlaseny_problem: {0}", (Object[])new Object[]{e});
        }
    }

    private void parseSoBezGeometrie(JsonObject obj) {
        try {
            JsonArray arr = obj.getJsonArray("so_bez_geometrie");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject soBezGeom = arr.getJsonObject(i);
                ObjectWithoutGeometry so = new ObjectWithoutGeometry();
                try {
                    so.setRuianID(Long.parseLong(soBezGeom.getString("ruian_id", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.ruian_id:", (Throwable)e);
                }
                try {
                    so.setPodlazi(Integer.parseInt(soBezGeom.getString("pocet_podlazi", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.pocet_podlazi:", (Throwable)e);
                }
                try {
                    so.setByty(Integer.parseInt(soBezGeom.getString("pocet_bytu", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"so_bez_geometrie.pocet_bytu:", (Throwable)e);
                }
                so.setZpusobVyuziti(soBezGeom.getString("zpusob_vyuziti", ""));
                so.setZpusobVyuzitiKod(soBezGeom.getString("zpusob_vyuziti_kod", ""));
                so.setZpusobVyuzitiKey(soBezGeom.getString("zpusob_vyuziti_key", ""));
                so.setZpusobVyuzitiVal(soBezGeom.getString("zpusob_vyuziti_val", ""));
                so.setDokonceni(soBezGeom.getString("dokonceni", ""));
                so.setPlatiOd(soBezGeom.getString("plati_od", ""));
                try {
                    so.setVzdalenost(Float.parseFloat(soBezGeom.getString("vzdalenost", "")));
                }
                catch (NumberFormatException e) {
                    Logging.warn((String)"so_bez_geometrie.vzdalenost: {0}", (Object[])new Object[]{e});
                }
                this.mSoBezGeometrie.add(so);
            }
        }
        catch (ClassCastException e) {
            Logging.warn((String)"so_bez_geometrie: {0}", (Object[])new Object[]{e});
        }
    }

    private void parseAdresniMista(JsonObject obj) {
        try {
            JsonArray arr = obj.getJsonArray("adresni_mista");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject adresniMisto = arr.getJsonObject(i);
                AddrPlaces am = new AddrPlaces();
                try {
                    am.setRuianID(Long.parseLong(adresniMisto.getString("ruian_id", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.ruian_id:", (Throwable)e);
                }
                try {
                    JsonArray node = adresniMisto.getJsonArray("pozice");
                    if (node.size() >= 2) {
                        am.setPosition(new LatLon(LatLon.roundToOsmPrecision((double)node.getJsonNumber(1).doubleValue()), LatLon.roundToOsmPrecision((double)node.getJsonNumber(0).doubleValue())));
                    }
                }
                catch (ClassCastException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.pozice:", (Throwable)e);
                }
                try {
                    am.setBudovaID(Long.parseLong(adresniMisto.getString("budova_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.budova_kod:", (Throwable)e);
                }
                am.setCisloTyp(adresniMisto.getString("cislo_typ", ""));
                am.setCisloDomovni(adresniMisto.getString("cislo_domovni", ""));
                am.setCisloOrientacni(adresniMisto.getString("cislo_orientacni", ""));
                try {
                    am.setUliceID(Long.parseLong(adresniMisto.getString("ulice_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.ulice_kod:", (Throwable)e);
                }
                am.setUlice(adresniMisto.getString("ulice", ""));
                try {
                    am.setCastObceID(Long.parseLong(adresniMisto.getString("cast_obce_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.cast_obce_kod:", (Throwable)e);
                }
                am.setCastObce(adresniMisto.getString("cast_obce", ""));
                try {
                    am.setMestskaCastID(Long.parseLong(adresniMisto.getString("mestska_cast_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.mestska_cast_kod:", (Throwable)e);
                }
                am.setMestskaCast(adresniMisto.getString("mestska_cast", ""));
                try {
                    am.setObecID(Long.parseLong(adresniMisto.getString("obec_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.obec_kod:", (Throwable)e);
                }
                am.setObec(adresniMisto.getString("obec", ""));
                try {
                    am.setOkresID(Long.parseLong(adresniMisto.getString("okres_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.okres_kod:", (Throwable)e);
                }
                am.setOkres(adresniMisto.getString("okres", ""));
                try {
                    am.setKrajID(Long.parseLong(adresniMisto.getString("kraj_kod", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.kraj_kod:", (Throwable)e);
                }
                am.setKraj(adresniMisto.getString("kraj", ""));
                am.setPsc(adresniMisto.getString("psc", ""));
                try {
                    am.setVzdalenost(Float.parseFloat(adresniMisto.getString("vzdalenost", "")));
                }
                catch (NumberFormatException e) {
                    Logging.log((Level)Level.WARNING, (String)"adresni_mista.vzdalenost:", (Throwable)e);
                }
                this.mAdresniMista.add(am);
            }
        }
        catch (ClassCastException e) {
            Logging.log((Level)Level.WARNING, (String)"adresni_mista:", (Throwable)e);
        }
    }

    private void parseParcela(JsonObject obj) {
        try {
            JsonObject parcela = RuianRecord.getSafeJsonObject(obj, "parcela");
            try {
                this.mParcelaRuianId = Long.parseLong(parcela.getString("ruian_id", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"parcela.ruian_id:", (Throwable)e);
            }
            this.mParcelaDruhPozemku = parcela.getString("druh_pozemku", "");
            this.mParcelaZpusobVyuziti = parcela.getString("zpusob_vyuziti", "");
            this.mParcelaPlatiOd = parcela.getString("plati_od", "");
        }
        catch (InvalidArgumentException e) {
            Logging.log((Level)Level.WARNING, (String)"parcela:", (Throwable)e);
        }
    }

    private void parseUlice(JsonObject obj) {
        try {
            JsonObject ulice = RuianRecord.getSafeJsonObject(obj, "ulice");
            try {
                this.mUliceRuianId = Long.parseLong(ulice.getString("ruian_id", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"ulice.ruian_id:", (Throwable)e);
            }
            this.mUliceJmeno = ulice.getString("jmeno", "");
        }
        catch (IllegalArgumentException e) {
            Logging.log((Level)Level.WARNING, (String)"ulice:", (Throwable)e);
        }
    }

    private void parseKatastr(JsonObject obj) {
        try {
            JsonObject katastr = RuianRecord.getSafeJsonObject(obj, "katastr");
            try {
                this.mKatastrRuianId = Long.parseLong(katastr.getString("ruian_id", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.ruian_id:", (Throwable)e);
            }
            this.mKatastrNazev = katastr.getString("nazev", "");
            try {
                this.mKatastrObecKod = Long.parseLong(katastr.getString("obec_kod", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.obec_kod:", (Throwable)e);
            }
            this.mKatastrObec = katastr.getString("obec", "");
            try {
                this.mKatastrOkresKod = Long.parseLong(katastr.getString("okres_kod", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.okres_kod:", (Throwable)e);
            }
            this.mKatastrOkres = katastr.getString("okres", "");
            try {
                this.mKatastrKrajKod = Long.parseLong(katastr.getString("kraj_kod", ""));
            }
            catch (NumberFormatException e) {
                Logging.log((Level)Level.WARNING, (String)"katastr.kraj_kod:", (Throwable)e);
            }
            this.mKatastrKraj = katastr.getString("kraj", "");
        }
        catch (IllegalArgumentException e) {
            Logging.log((Level)Level.WARNING, (String)"katastr:", (Throwable)e);
        }
    }

    public String getHtml() {
        String iconExtLink = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link.png") + " border=0 alt=\"Zobrazit na extern\u00edch str\u00e1nk\u00e1ch\"/>";
        String iconExtLinkRuian = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch RUIAN\"/>";
        String iconExtLinkKn = "<img src=" + this.getClass().getResource("/images/dialogs/open-external-link-kn.png") + " border=0 alt=\"Zobrazit na str\u00e1nk\u00e1ch katastru nemovitost\u00ed\"/>";
        String iconCopyTags = "<img src=" + this.getClass().getResource("/images/dialogs/copy-tags.png") + " border=0 alt=\"Kop\u00edrovat tagy\"/>";
        String iconCreateAddr = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod\"/>";
        String iconCreateAddrRuian = "<img src=" + this.getClass().getResource("/images/dialogs/create-addr-ruian.png") + " border=0 alt=\"Vytvo\u0159it adresn\u00ed bod dle RUIANu\"/>";
        String iconRuianError = "<img src=" + this.getClass().getResource("/images/dialogs/create-bug-report.png") + " border=0 alt=\"Nahl\u00e1sit probl\u00e9m v datech\"/>";
        String urlCpost = "https://www.postaonline.cz/vyhledani-psc?p_p_id=psc_WAR_pcpvpp&p_p_lifecycle=1&p_p_state=normal&p_p_mode=view&p_p_col_id=column-1&p_p_col_count=1&_psc_WAR_pcpvpp_struts.portlet.action=%2Fview%2FdetailPost&_psc_WAR_pcpvpp_struts.portlet.mode=view&_psc_WAR_pcpvpp_zipCode=";
        String urlStavebniObjekt = "https://vdp.cuzk.cz/vdp/ruian/stavebniobjekty/";
        String urlAdresniMisto = "https://vdp.cuzk.cz/vdp/ruian/adresnimista/";
        String urlParcela = "https://vdp.cuzk.cz/vdp/ruian/parcely/";
        String urlKatastralniUzemi = "https://vdp.cuzk.cz/vdp/ruian/katastralniuzemi/";
        String urlUlice = "https://vdp.cuzk.cz/vdp/ruian/ulice/";
        String urlMistniCast = "https://vdp.cuzk.cz/vdp/ruian/castiobce/";
        String urlMestskaCast = "https://vdp.cuzk.cz/vdp/ruian/mestskecasti/";
        String urlObec = "https://vdp.cuzk.cz/vdp/ruian/obce/";
        String urlOkres = "https://vdp.cuzk.cz/vdp/ruian/okresy/";
        String urlKraj = "https://vdp.cuzk.cz/vdp/ruian/vusc/";
        String urlVlastnici = "https://vdp.cuzk.cz/vdp/ruian/vlastnici?typ=";
        String urlRuianError = "http://ruian.poloha.net/building.php?kod=";
        StringBuilder r = new StringBuilder();
        if (this.mObjektRuianId == 0L && this.mParcelaRuianId == 0L && this.mAdresniMista.isEmpty() && this.mUliceRuianId == 0L && this.mKatastrRuianId == 0L) {
            return "";
        }
        r.append("<html><body bgcolor=\"white\" color=\"black\" ><table><tr><td>");
        r.append("<br/>");
        if (this.mObjektRuianId > 0L) {
            int i;
            r.append("<i><u>Informace o budov\u011b</u></i><br/>").append("<b>RUIAN id: </b>").append(this.mObjektRuianId).append("&nbsp;&nbsp;<a href=").append(urlStavebniObjekt).append(this.mObjektRuianId).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=").append(urlVlastnici).append("so&id=").append(this.mObjektRuianId).append(">").append(iconExtLinkKn).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/building>").append(iconCopyTags).append("</a>").append("&nbsp;&nbsp;<a href=").append(urlRuianError).append(this.mObjektRuianId).append(">").append(iconRuianError).append("</a><br/>");
            if (this.mAdresniMista.isEmpty()) {
                r.append("<b>Budova: </b> bez \u010d.p./\u010d.e<br/>");
            } else if ("\u010c\u00edslo popisn\u00e9".equals(this.mAdresniMista.get(0).getCisloTyp())) {
                r.append("<b>Budova: </b>s \u010d\u00edslem popisn\u00fdm<br/>");
            } else {
                r.append("<b>Budova: </b>s \u010d\u00edslem eviden\u010dn\u00edm<br/>");
            }
            if (this.mObjektPodlazi > 0) {
                r.append("<b>Po\u010det podla\u017e\u00ed: </b>").append(this.mObjektPodlazi).append("<br/>");
            }
            if (this.mObjektByty > 0) {
                r.append("<b>Po\u010det byt\u016f: </b>").append(this.mObjektByty).append("<br/>");
            }
            r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>").append(this.mObjektZpusobVyuziti).append("<br/>").append("<b>Datum dokon\u010den\u00ed: </b>").append(this.mObjektDokonceni).append("<br/>").append("<b>Plat\u00ed od: </b>").append(this.mObjektPlatiOd).append("<br/>");
            if (this.mAdresniMista.size() > 1) {
                r.append("<i><u>Informace o adrese</u></i><br/>");
                i = 0;
                r.append("<br/>").append("<b>").append(this.mAdresniMista.get(i).getCisloTyp()).append("</b> (v\u00edce adres)<b>: </b>").append(this.mAdresniMista.get(i).getCisloDomovni()).append("<br/>").append("<b>\u010c\u00e1st obce: </b>").append(this.mAdresniMista.get(i).getCastObce()).append("&nbsp;&nbsp;<a href=").append(urlMistniCast).append(this.mAdresniMista.get(i).getCastObceID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                if (!this.mAdresniMista.get(i).getMestskaCast().isEmpty()) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>").append(this.mAdresniMista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=").append(urlMestskaCast).append(this.mAdresniMista.get(i).getMestskaCastID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                }
                r.append("<b>Obec: </b>").append(this.mAdresniMista.get(i).getObec()).append("&nbsp;&nbsp;<a href=").append(urlObec).append(this.mAdresniMista.get(i).getObecID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Okres: </b>").append(this.mAdresniMista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=").append(urlOkres).append(this.mAdresniMista.get(i).getOkresID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Kraj: </b>").append(this.mAdresniMista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=").append(urlKraj).append(this.mAdresniMista.get(i).getKrajID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
            } else if (this.mAdresniMista.size() == 1 && (this.mAdresniMista.get(0).getCisloDomovni() == null || this.mAdresniMista.get(0).getCisloDomovni().isEmpty())) {
                i = 0;
                r.append("<br/>").append("<i><u>Informace o adrese</u></i><br/>").append("<b>Budova: </b>").append(this.mAdresniMista.get(i).getCisloTyp()).append("<br/>");
                if (this.mAdresniMista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>").append(this.mAdresniMista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=").append(urlMestskaCast).append(this.mAdresniMista.get(i).getMestskaCastID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                }
                r.append("<b>Obec: </b>").append(this.mAdresniMista.get(i).getObec()).append("&nbsp;&nbsp;<a href=").append(urlObec).append(this.mAdresniMista.get(i).getObecID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Okres: </b>").append(this.mAdresniMista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=").append(urlOkres).append(this.mAdresniMista.get(i).getOkresID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Kraj: </b>").append(this.mAdresniMista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=").append(urlKraj).append(this.mAdresniMista.get(i).getKrajID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
            } else if (this.mAdresniMista.size() == 1) {
                i = 0;
                Object x = "";
                String xName = "";
                if (!this.mAdresniMista.get(i).getCisloOrientacni().isEmpty()) {
                    x = "/" + this.mAdresniMista.get(i).getCisloOrientacni();
                    xName = "/orienta\u010dn\u00ed";
                }
                r.append("<br/>").append("<i><u>Informace o adrese</u></i><br/>").append("<b>RUIAN id: </b>").append(this.mAdresniMista.get(i).getRuianID()).append("&nbsp;&nbsp;<a href=").append(urlAdresniMisto).append(this.mAdresniMista.get(i).getRuianID()).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:").append(i).append(">").append(iconCopyTags).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:").append(i).append(">").append(iconCreateAddr).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:").append(i).append(">").append(iconCreateAddrRuian).append("</a><br/>").append("<b>").append(this.mAdresniMista.get(i).getCisloTyp()).append(xName).append(": </b>").append(this.mAdresniMista.get(i).getCisloDomovni()).append((String)x).append("<br/>");
                if (!this.mAdresniMista.get(i).getUlice().isEmpty()) {
                    r.append("<b>Ulice: </b>").append(this.mAdresniMista.get(i).getUlice()).append("&nbsp;&nbsp;<a href=").append(urlUlice).append(this.mAdresniMista.get(i).getUliceID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                }
                r.append("<b>\u010c\u00e1st obce: </b>").append(this.mAdresniMista.get(i).getCastObce()).append("&nbsp;&nbsp;<a href=").append(urlMistniCast).append(this.mAdresniMista.get(i).getCastObceID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                if (this.mAdresniMista.get(i).getMestskaCast().length() > 0) {
                    r.append("<b>M\u011bstsk\u00e1 \u010d\u00e1st: </b>").append(this.mAdresniMista.get(i).getMestskaCast()).append("&nbsp;&nbsp;<a href=").append(urlMestskaCast).append(this.mAdresniMista.get(i).getMestskaCastID()).append(">").append(iconExtLinkRuian).append("</a><br/>");
                }
                r.append("<b>Obec: </b>").append(this.mAdresniMista.get(i).getObec()).append("&nbsp;&nbsp;<a href=").append(urlObec).append(this.mAdresniMista.get(i).getObecID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Okres: </b>").append(this.mAdresniMista.get(i).getOkres()).append("&nbsp;&nbsp;<a href=").append(urlOkres).append(this.mAdresniMista.get(i).getOkresID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Kraj: </b>").append(this.mAdresniMista.get(i).getKraj()).append("&nbsp;&nbsp;<a href=").append(urlKraj).append(this.mAdresniMista.get(i).getKrajID()).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>PS\u010c: </b>").append(this.mAdresniMista.get(i).getPsc()).append("&nbsp;&nbsp;<a href=").append(urlCpost).append(this.mAdresniMista.get(i).getPsc()).append(">").append(iconExtLinkRuian).append("</a><br/>");
            }
            r.append("<br/>");
        }
        if (this.mObjektRuianId > 0L && !this.mErrUser.isEmpty()) {
            r.append("<i><u>Nahl\u00e1\u0161en\u00fd probl\u00e9m</u></i>").append("&nbsp;&nbsp;<a href=").append(urlRuianError).append(this.mObjektRuianId).append(">").append(iconExtLink).append("</a><br/>").append("<b>Nahl\u00e1sil: </b>").append(this.mErrUser).append("<br/>").append("<b>Dne: </b>").append(this.mErrDate).append("<br/>").append("<b>Typ probl\u00e9mu: </b>").append(this.mErrType).append("<br/>");
            if (!this.mErrNote.isEmpty()) {
                r.append("<b>Pozn\u00e1mka: </b>").append(this.mErrNote).append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.mAdresniMista.size() > 1 && this.mObjektRuianId > 0L) {
            String x = "";
            if ("\u010c\u00edslo eviden\u010dn\u00ed".equals(this.mAdresniMista.get(0).getCisloTyp())) {
                x = "ev.";
            }
            r.append("<i><u>Adresn\u00ed m\u00edsta</u></i><br/>");
            for (int i = 0; i < this.mAdresniMista.size(); ++i) {
                r.append(this.mAdresniMista.get(i).getUlice()).append(" ").append(x).append(this.mAdresniMista.get(i).getCisloDomovni());
                if (!this.mAdresniMista.get(i).getCisloOrientacni().isEmpty()) {
                    r.append("/").append(this.mAdresniMista.get(i).getCisloOrientacni());
                }
                r.append("&nbsp;&nbsp;<a href=").append(urlAdresniMisto).append(this.mAdresniMista.get(i).getRuianID()).append(">").append(iconExtLinkRuian).append("</a> ").append("&nbsp;&nbsp;<a href=file://tags.copy/address:").append(i).append(">").append(iconCopyTags).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:").append(i).append(">").append(iconCreateAddr).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:").append(i).append(">").append(iconCreateAddrRuian).append("</a>").append("<br/>");
            }
            r.append("<br/>");
        }
        if (this.mParcelaRuianId > 0L) {
            r.append("<i><u>Informace o pozemku</u></i>").append("<br/>").append("<b>RUIAN id: </b>").append(this.mParcelaRuianId).append("&nbsp;&nbsp;<a href=").append(urlParcela).append(this.mParcelaRuianId).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=").append(urlVlastnici).append("pa&id=").append(this.mParcelaRuianId).append(">").append(iconExtLinkKn).append("</a><br/>").append("<b>Druh pozemku: </b>").append(this.mParcelaDruhPozemku).append("<br/>");
            if (!"".equals(this.mParcelaZpusobVyuziti)) {
                r.append("<b>Zp\u016fsob vyu\u017eit\u00ed: </b>").append(this.mParcelaZpusobVyuziti).append("<br/>");
            }
            r.append("<b>Plat\u00ed od: </b>").append(this.mParcelaPlatiOd).append("<br/>").append("<br/>");
        }
        if (this.mUliceRuianId > 0L) {
            r.append("<i><u>Informace o ulici</u></i><br/>").append("<b>RUIAN id: </b>").append(this.mUliceRuianId).append("&nbsp;&nbsp;<a href=").append(urlUlice).append(this.mUliceRuianId).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/street>").append(iconCopyTags).append("</a><br/>").append("<b>Jm\u00e9no: </b>").append(this.mUliceJmeno).append("<br/>").append("<br/>");
        }
        if (this.mKatastrRuianId > 0L) {
            r.append("<b>Katastr\u00e1ln\u00ed \u00fazem\u00ed: </b>").append(this.mKatastrNazev).append("&nbsp;&nbsp;<a href=").append(urlKatastralniUzemi).append(this.mKatastrRuianId).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Obec: </b>").append(this.mKatastrObec).append("&nbsp;&nbsp;<a href=").append(urlObec).append(this.mKatastrObecKod).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Okres: </b>").append(this.mKatastrOkres).append("&nbsp;&nbsp;<a href=").append(urlOkres).append(this.mKatastrOkresKod).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<b>Kraj: </b>").append(this.mKatastrKraj).append("&nbsp;&nbsp;<a href=").append(urlKraj).append(this.mKatastrKrajKod).append(">").append(iconExtLinkRuian).append("</a><br/>").append("<br/>");
        }
        if (!this.mAdresniMista.isEmpty() && this.mObjektRuianId == 0L) {
            r.append("<i><u>Adresn\u00ed m\u00edsta v okol\u00ed</u></i><br/>").append("<table>");
            for (int i = 0; i < this.mAdresniMista.size(); ++i) {
                StringBuilder x = new StringBuilder();
                if ("\u010c\u00edslo eviden\u010dn\u00ed".equals(this.mAdresniMista.get(i).getCisloTyp())) {
                    x.append("ev.");
                }
                x.append(this.mAdresniMista.get(i).getCisloDomovni());
                if (!this.mAdresniMista.get(i).getCisloOrientacni().isEmpty()) {
                    x.append("/").append(this.mAdresniMista.get(i).getCisloOrientacni());
                }
                r.append("<tr><td bgcolor=#e5e5ff>");
                if (!this.mAdresniMista.get(i).getUlice().isEmpty()) {
                    r.append(this.mAdresniMista.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.mAdresniMista.get(i).getUlice()).append(" ").append((CharSequence)x).append("<br/><u>").append(this.mAdresniMista.get(i).getObec()).append("</u>").append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("<a href=").append(urlAdresniMisto).append(this.mAdresniMista.get(i).getRuianID()).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:").append(i).append(">").append(iconCopyTags).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:").append(i).append(">").append(iconCreateAddr).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:").append(i).append(">").append(iconCreateAddrRuian).append("</a>");
                } else {
                    r.append(this.mAdresniMista.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.mAdresniMista.get(i).getCastObce()).append(" ").append((CharSequence)x).append("&nbsp;");
                    if (!this.mAdresniMista.get(i).getCastObce().equals(this.mAdresniMista.get(i).getObec())) {
                        r.append("<br/><u>").append(this.mAdresniMista.get(i).getObec()).append("</u>");
                    }
                    r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("<a href=").append(urlAdresniMisto).append(this.mAdresniMista.get(i).getRuianID()).append(">").append(iconExtLinkRuian).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.copy/address:").append(i).append(">").append(iconCopyTags).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create/address:").append(i).append(">").append(iconCreateAddr).append("</a>").append("&nbsp;&nbsp;<a href=file://tags.create-on-place/address:").append(i).append(">").append(iconCreateAddrRuian).append("</a>");
                }
                r.append("</td></tr>");
            }
            r.append("</table><br/>");
        }
        if (!this.mSoBezGeometrie.isEmpty()) {
            r.append("<i><u>Budovy bez geometrie v okol\u00ed</u></i><br/>").append("<table>");
            for (int i = 0; i < this.mSoBezGeometrie.size(); ++i) {
                r.append("<tr><td bgcolor=#e5e5ff>").append(this.mSoBezGeometrie.get(i).getVzdalenost()).append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append(this.mSoBezGeometrie.get(i).getRuianID());
                if (this.mSoBezGeometrie.get(i).getZpusobVyuziti().length() > 0) {
                    r.append(" - ").append(this.mSoBezGeometrie.get(i).getZpusobVyuziti());
                }
                r.append("</td><td valign=\"top\"  bgcolor=#e5e5ff>").append("&nbsp;&nbsp;<a href=").append(urlStavebniObjekt).append(this.mSoBezGeometrie.get(i).getRuianID()).append(">").append(iconExtLinkRuian).append("</a> ").append("&nbsp;&nbsp;<a href=file://tags.copy/ghost:").append(i).append(">").append(iconCopyTags).append("</a></br>").append("</td></tr>");
            }
            r.append("</table><br/>").append("<br/>");
        }
        r.append("<hr/>").append("<center><i><small>Zdroj: <a href=\"http://www.ruian.cz/\">").append(this.mSource).append("</a></small></i></center>").append("</td></tr></table></body></html>");
        return r.toString();
    }

    String convertDate(String ruianDate) {
        String[] parts = ruianDate.split("\\.");
        try {
            int day = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]);
            int year = Integer.parseInt(parts[2]);
            return year + "-" + String.format("%02d", month) + "-" + String.format("%02d", day);
        }
        catch (NumberFormatException | IllegalFormatException e) {
            Logging.warn((Throwable)e);
            return "";
        }
    }

    String tagToString(String k, String v) {
        return "\"" + k + "\"=\"" + v + "\"\n";
    }

    String getKeys(String keyType) {
        StringBuilder c = new StringBuilder();
        if ("building".equals(keyType) && this.mObjektRuianId > 0L) {
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.mObjektRuianId)));
            if (!this.mObjektZpusobVyuzitiKey.isEmpty() && !this.mObjektZpusobVyuzitiVal.isEmpty()) {
                c.append(this.tagToString(this.mObjektZpusobVyuzitiKey, this.mObjektZpusobVyuzitiVal));
            }
            if (this.mObjektPodlazi > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.mObjektPodlazi)));
            }
            if (this.mObjektByty > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.mObjektByty)));
            }
            if (this.mObjektDokonceni.length() > 0 && this.convertDate(this.mObjektDokonceni).length() > 0) {
                c.append(this.tagToString("start_date", this.convertDate(this.mObjektDokonceni)));
            }
            if (this.mObjektZpusobVyuzitiKod.length() > 0) {
                c.append(this.tagToString("building:ruian:type", this.mObjektZpusobVyuzitiKod));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("ghost") && !this.mSoBezGeometrie.isEmpty()) {
            String[] key = keyType.split(":");
            int i = Integer.parseInt(key[1]);
            Logging.trace((String)"Ghost ID: {0}", (Object[])new Object[]{i});
            c.append(this.tagToString("ref:ruian:building", Long.toString(this.mSoBezGeometrie.get(i).getRuianID())));
            if (this.mSoBezGeometrie.get(i).getZpusobVyuzitiKey().length() > 0 && this.mSoBezGeometrie.get(i).getZpusobVyuzitiVal().length() > 0) {
                c.append(this.tagToString(this.mSoBezGeometrie.get(i).getZpusobVyuzitiKey(), this.mSoBezGeometrie.get(i).getZpusobVyuzitiVal()));
            }
            if (this.mSoBezGeometrie.get(i).getPodlazi() > 0) {
                c.append(this.tagToString("building:levels", Integer.toString(this.mSoBezGeometrie.get(i).getPodlazi())));
            }
            if (this.mSoBezGeometrie.get(i).getByty() > 0) {
                c.append(this.tagToString("building:flats", Integer.toString(this.mSoBezGeometrie.get(i).getByty())));
            }
            if (this.mSoBezGeometrie.get(i).getDokonceni().length() > 0 && this.convertDate(this.mSoBezGeometrie.get(i).getDokonceni()).length() > 0) {
                c.append(this.tagToString("start_date", this.convertDate(this.mSoBezGeometrie.get(i).getDokonceni())));
            }
            if (this.mSoBezGeometrie.get(i).getZpusobVyuzitiKod().length() > 0) {
                c.append(this.tagToString("building:ruian:type", this.mSoBezGeometrie.get(i).getZpusobVyuzitiKod()));
            }
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        if (keyType.startsWith("address") && !this.mAdresniMista.isEmpty()) {
            String[] key = keyType.split(":");
            int i = Integer.parseInt(key[1]);
            Logging.info((String)("Address ID: " + i));
            if (!"\u010c\u00edslo eviden\u010dn\u00ed".equals(this.mAdresniMista.get(i).getCisloTyp())) {
                c.append(this.tagToString("addr:conscriptionnumber", this.mAdresniMista.get(i).getCisloDomovni()));
            } else {
                c.append(this.tagToString("addr:provisionalnumber", this.mAdresniMista.get(i).getCisloDomovni()));
            }
            if (!this.mAdresniMista.get(i).getCisloOrientacni().isEmpty()) {
                c.append(this.tagToString("addr:streetnumber", this.mAdresniMista.get(i).getCisloOrientacni()));
            }
            StringBuilder addr = new StringBuilder();
            if (!"\u010c\u00edslo eviden\u010dn\u00ed".equals(this.mAdresniMista.get(i).getCisloTyp())) {
                addr.append(this.mAdresniMista.get(i).getCisloDomovni());
            } else {
                addr.append("ev.").append(this.mAdresniMista.get(i).getCisloDomovni());
            }
            if (!this.mAdresniMista.get(i).getCisloOrientacni().isEmpty()) {
                addr.append("/").append(this.mAdresniMista.get(i).getCisloOrientacni());
            }
            c.append(this.tagToString("addr:housenumber", addr.toString()));
            if (!this.mAdresniMista.get(i).getUlice().isEmpty()) {
                c.append(this.tagToString("addr:street", this.mAdresniMista.get(i).getUlice()));
            }
            if (this.mAdresniMista.get(i).getRuianID() > 0L) {
                c.append(this.tagToString("ref:ruian:addr", Long.toString(this.mAdresniMista.get(i).getRuianID())));
            }
            if (!this.mAdresniMista.get(i).getCastObce().isEmpty()) {
                c.append(this.tagToString("addr:place", this.mAdresniMista.get(i).getCastObce()));
            }
            if (!this.mAdresniMista.get(i).getMestskaCast().isEmpty()) {
                c.append(this.tagToString("addr:suburb", this.mAdresniMista.get(i).getMestskaCast()));
            }
            if (!this.mAdresniMista.get(i).getObec().isEmpty()) {
                c.append(this.tagToString("addr:city", this.mAdresniMista.get(i).getObec()));
            }
            if (!this.mAdresniMista.get(i).getPsc().isEmpty()) {
                c.append(this.tagToString("addr:postcode", this.mAdresniMista.get(i).getPsc()));
            }
            c.append(this.tagToString("addr:country", "CZ"));
            c.append(this.tagToString("source:addr", "cuzk:ruian"));
        }
        if ("street".equals(keyType) && this.mUliceRuianId > 0L) {
            c.append(this.tagToString("ref:ruian:street", Long.toString(this.mUliceRuianId)));
            c.append(this.tagToString("name", this.mUliceJmeno));
            c.append(this.tagToString("source", "cuzk:ruian"));
        }
        return c.toString();
    }

    void createAddrPoint(String cmd, String t) {
        Node node;
        LinkedList<AddCommand> commands = new LinkedList<AddCommand>();
        if (cmd.startsWith("tags.create-on-place")) {
            String[] key = cmd.split(":");
            int i = Integer.parseInt(key[1]);
            node = new Node(this.mAdresniMista.get(i).getPosition());
        } else {
            node = new Node(new LatLon(this.mCoorLat, this.mCoorLon));
        }
        commands.add(new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)node));
        LinkedList<Node> coll = new LinkedList<Node>();
        coll.add(node);
        TagCollection tc = new TagCollection();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(t.split("\n")));
        for (String line : list) {
            String[] tag = line.split("\"=\"");
            Logging.info((String)("<" + tag[0] + ">. <" + tag[1] + ">"));
            tc.add(new Tag(tag[0].substring(1), tag[1].substring(0, tag[1].length() - 1)));
        }
        tc.applyTo(coll);
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Add new address point", (Object[])new Object[0]), commands));
    }

    public void performAction(String act) {
        Logging.info((String)("act: " + act.substring(7)));
        String[] params = act.substring(7).split("/");
        if (!"tags.copy".equals(params[0]) && !params[0].startsWith("tags.create")) {
            return;
        }
        String task = this.getKeys(params[1]);
        if ("tags.copy".equals(params[0]) && !task.isEmpty()) {
            ClipboardUtils.copyString((String)task);
            PointInfoUtils.showNotification(I18n.tr((String)"Tags copied to clipboard.", (Object[])new Object[0]), "info");
        }
        if (params[0].startsWith("tags.create") && !task.isEmpty()) {
            this.createAddrPoint(act.substring(7), task);
            PointInfoUtils.showNotification(I18n.tr((String)"New address point added.", (Object[])new Object[0]), "info");
        }
    }
}

