/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.util.logging.Logger;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionContext;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.tagspec.TagSpecifications;

public class TagSpecificationAwareTagCellEditor
extends TagCellEditor {
    private static final Logger logger = Logger.getLogger(TagCellEditor.class.getName());

    public TagSpecificationAwareTagCellEditor() {
        super(0);
    }

    protected void initAutoCompletionListForKeys(TagEditorModel model, TagModel currentTag) {
        if (this.getAutoCompletionList() == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithKeys(this.autoCompletionList);
        AutoCompletionContext context = new AutoCompletionContext();
        try {
            context.initFromJOSMSelection();
            this.autoCompletionList.add(TagSpecifications.getInstance().getKeysForAutoCompletion(context));
        }
        catch (Exception e) {
            System.out.println("Warning: failed to initialize auto completion list with tag specification keys. Exception was: " + e.toString());
            e.printStackTrace();
        }
        for (String key : model.getKeys()) {
            if (key.equals(currentTag.getName())) continue;
            this.autoCompletionList.remove(key);
        }
        this.autoCompletionList.fireTableDataChanged();
    }

    protected void initAutoCompletionListForValues(String forKey) {
        if (this.autoCompletionList == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithTagValues(this.autoCompletionList, forKey);
        AutoCompletionContext context = new AutoCompletionContext();
        try {
            context.initFromJOSMSelection();
            this.autoCompletionList.add(TagSpecifications.getInstance().getLabelsForAutoCompletion(forKey, context));
        }
        catch (Exception e) {
            System.out.println("Warning: failed to initialize auto completion list with tag specification values. Exception was: " + e.toString());
            e.printStackTrace();
        }
        if (this.currentTag.getValueCount() > 1) {
            for (String value : this.currentTag.getValues()) {
                this.autoCompletionList.add(new AutoCompletionItem(value, AutoCompletionPriority.IS_IN_SELECTION));
            }
        }
    }
}

