/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.columbusCSV;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class ColumbusCSVPreferences
extends DefaultTabPreferenceSetting {
    public static final String PREFIX = "columbuscsv.";
    public static final String SHOW_SUMMARY = "columbuscsv.import.showSummary";
    public static final String ZOOM_AFTER_IMPORT = "columbuscsv.import.dontZoomAfterImport";
    public static final String IGNORE_VDOP = "columbuscsv.import.ignoreVDOP";
    public static final String WARN_MISSING_AUDIO = "columbuscsv.warn.missingAudio";
    public static final String WARN_CONVERSION_ERRORS = "columbuscsv.warn.conversionErrors";
    private final JCheckBox colCSVShowSummary = new JCheckBox(I18n.tr((String)"Show summary after import", (Object[])new Object[0]));
    private final JCheckBox colCSVDontZoomAfterImport = new JCheckBox(I18n.tr((String)"Do not zoom after import", (Object[])new Object[0]));
    private final JCheckBox colCSVIgnoreVDOP = new JCheckBox(I18n.tr((String)"Ignore hdop/vdop/pdop entries", (Object[])new Object[0]));
    private final JCheckBox colCSVWarnMissingAudio = new JCheckBox(I18n.tr((String)"Warn on missing audio files", (Object[])new Object[0]));
    private final JCheckBox colCSVWarnConversionErrors = new JCheckBox(I18n.tr((String)"Warn on conversion errors", (Object[])new Object[0]));

    public boolean ok() {
        Config.getPref().putBoolean(SHOW_SUMMARY, this.colCSVShowSummary.isSelected());
        Config.getPref().putBoolean(ZOOM_AFTER_IMPORT, this.colCSVDontZoomAfterImport.isSelected());
        Config.getPref().putBoolean(IGNORE_VDOP, this.colCSVIgnoreVDOP.isSelected());
        Config.getPref().putBoolean(WARN_CONVERSION_ERRORS, this.colCSVWarnConversionErrors.isSelected());
        Config.getPref().putBoolean(WARN_MISSING_AUDIO, this.colCSVWarnMissingAudio.isSelected());
        return false;
    }

    public static boolean showSummary() {
        return Config.getPref().getBoolean(SHOW_SUMMARY, true);
    }

    public static boolean zoomAfterImport() {
        return Config.getPref().getBoolean(ZOOM_AFTER_IMPORT, true);
    }

    public static boolean ignoreDOP() {
        return Config.getPref().getBoolean(IGNORE_VDOP, false);
    }

    public static boolean warnConversion() {
        return Config.getPref().getBoolean(WARN_CONVERSION_ERRORS, false);
    }

    public static boolean warnMissingAudio() {
        return Config.getPref().getBoolean(WARN_MISSING_AUDIO, false);
    }

    public void addGui(PreferenceTabbedPane gui) {
        ButtonGroup gpsImportGroup = new ButtonGroup();
        gpsImportGroup.add(this.colCSVShowSummary);
        gpsImportGroup.add(this.colCSVDontZoomAfterImport);
        gpsImportGroup.add(this.colCSVIgnoreVDOP);
        ButtonGroup gpsWarningsGroup = new ButtonGroup();
        gpsWarningsGroup.add(this.colCSVWarnMissingAudio);
        gpsWarningsGroup.add(this.colCSVWarnConversionErrors);
        this.colCSVShowSummary.setSelected(Config.getPref().getBoolean(SHOW_SUMMARY, true));
        this.colCSVDontZoomAfterImport.setSelected(Config.getPref().getBoolean(ZOOM_AFTER_IMPORT, true));
        this.colCSVIgnoreVDOP.setSelected(Config.getPref().getBoolean(IGNORE_VDOP, false));
        this.colCSVWarnConversionErrors.setSelected(Config.getPref().getBoolean(WARN_CONVERSION_ERRORS, true));
        this.colCSVWarnMissingAudio.setSelected(Config.getPref().getBoolean(WARN_MISSING_AUDIO, true));
    }

    public boolean isExpert() {
        return false;
    }
}

