/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.RobustClipEnvelopeComputer;
import org.locationtech.jts.util.Assert;

class OverlayUtil {
    private static final double SAFE_ENV_BUFFER_FACTOR = 0.1;
    private static final int SAFE_ENV_GRID_FACTOR = 3;
    private static final double AREA_HEURISTIC_TOLERANCE = 0.1;

    OverlayUtil() {
    }

    static boolean isFloating(PrecisionModel pm) {
        if (pm == null) {
            return true;
        }
        return pm.isFloating();
    }

    static Envelope clippingEnvelope(int opCode, InputGeometry inputGeom, PrecisionModel pm) {
        Envelope resultEnv = OverlayUtil.resultEnvelope(opCode, inputGeom, pm);
        if (resultEnv == null) {
            return null;
        }
        Envelope clipEnv = RobustClipEnvelopeComputer.getEnvelope(inputGeom.getGeometry(0), inputGeom.getGeometry(1), resultEnv);
        Envelope safeEnv = OverlayUtil.safeEnv(clipEnv, pm);
        return safeEnv;
    }

    private static Envelope resultEnvelope(int opCode, InputGeometry inputGeom, PrecisionModel pm) {
        Envelope overlapEnv = null;
        switch (opCode) {
            case 1: {
                Envelope envA = OverlayUtil.safeEnv(inputGeom.getEnvelope(0), pm);
                Envelope envB = OverlayUtil.safeEnv(inputGeom.getEnvelope(1), pm);
                overlapEnv = envA.intersection(envB);
                break;
            }
            case 3: {
                overlapEnv = OverlayUtil.safeEnv(inputGeom.getEnvelope(0), pm);
            }
        }
        return overlapEnv;
    }

    private static Envelope safeEnv(Envelope env, PrecisionModel pm) {
        double envExpandDist = OverlayUtil.safeExpandDistance(env, pm);
        Envelope safeEnv = env.copy();
        safeEnv.expandBy(envExpandDist);
        return safeEnv;
    }

    private static double safeExpandDistance(Envelope env, PrecisionModel pm) {
        double envExpandDist;
        if (OverlayUtil.isFloating(pm)) {
            double minSize = Math.min(env.getHeight(), env.getWidth());
            if (minSize <= 0.0) {
                minSize = Math.max(env.getHeight(), env.getWidth());
            }
            envExpandDist = 0.1 * minSize;
        } else {
            double gridSize = 1.0 / pm.getScale();
            envExpandDist = 3.0 * gridSize;
        }
        return envExpandDist;
    }

    static boolean isEmptyResult(int opCode, Geometry a, Geometry b, PrecisionModel pm) {
        switch (opCode) {
            case 1: {
                if (!OverlayUtil.isEnvDisjoint(a, b, pm)) break;
                return true;
            }
            case 3: {
                if (!OverlayUtil.isEmpty(a)) break;
                return true;
            }
            case 2: 
            case 4: {
                if (!OverlayUtil.isEmpty(a) || !OverlayUtil.isEmpty(b)) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isEmpty(Geometry geom) {
        return geom == null || geom.isEmpty();
    }

    static boolean isEnvDisjoint(Geometry a, Geometry b, PrecisionModel pm) {
        if (OverlayUtil.isEmpty(a) || OverlayUtil.isEmpty(b)) {
            return true;
        }
        if (OverlayUtil.isFloating(pm)) {
            return a.getEnvelopeInternal().disjoint(b.getEnvelopeInternal());
        }
        return OverlayUtil.isDisjoint(a.getEnvelopeInternal(), b.getEnvelopeInternal(), pm);
    }

    private static boolean isDisjoint(Envelope envA, Envelope envB, PrecisionModel pm) {
        if (pm.makePrecise(envB.getMinX()) > pm.makePrecise(envA.getMaxX())) {
            return true;
        }
        if (pm.makePrecise(envB.getMaxX()) < pm.makePrecise(envA.getMinX())) {
            return true;
        }
        if (pm.makePrecise(envB.getMinY()) > pm.makePrecise(envA.getMaxY())) {
            return true;
        }
        return pm.makePrecise(envB.getMaxY()) < pm.makePrecise(envA.getMinY());
    }

    static Geometry createEmptyResult(int dim, GeometryFactory geomFact) {
        Geometry result = null;
        switch (dim) {
            case 0: {
                result = geomFact.createPoint();
                break;
            }
            case 1: {
                result = geomFact.createLineString();
                break;
            }
            case 2: {
                result = geomFact.createPolygon();
                break;
            }
            case -1: {
                result = geomFact.createGeometryCollection();
                break;
            }
            default: {
                Assert.shouldNeverReachHere("Unable to determine overlay result geometry dimension");
            }
        }
        return result;
    }

    public static int resultDimension(int opCode, int dim0, int dim1) {
        int resultDimension = -1;
        switch (opCode) {
            case 1: {
                resultDimension = Math.min(dim0, dim1);
                break;
            }
            case 2: {
                resultDimension = Math.max(dim0, dim1);
                break;
            }
            case 3: {
                resultDimension = dim0;
                break;
            }
            case 4: {
                resultDimension = Math.max(dim0, dim1);
            }
        }
        return resultDimension;
    }

    static Geometry createResultGeometry(List<Polygon> resultPolyList, List<LineString> resultLineList, List<Point> resultPointList, GeometryFactory geometryFactory) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        if (resultPolyList != null) {
            geomList.addAll(resultPolyList);
        }
        if (resultLineList != null) {
            geomList.addAll(resultLineList);
        }
        if (resultPointList != null) {
            geomList.addAll(resultPointList);
        }
        return geometryFactory.buildGeometry(geomList);
    }

    static Geometry toLines(OverlayGraph graph, boolean isOutputEdges, GeometryFactory geomFact) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (OverlayEdge edge : graph.getEdges()) {
            boolean includeEdge;
            boolean bl = includeEdge = isOutputEdges || edge.isInResultArea();
            if (!includeEdge) continue;
            Coordinate[] pts = edge.getCoordinatesOriented();
            LineString line = geomFact.createLineString(pts);
            line.setUserData(OverlayUtil.labelForResult(edge));
            lines.add(line);
        }
        return geomFact.buildGeometry(lines);
    }

    private static String labelForResult(OverlayEdge edge) {
        return edge.getLabel().toString(edge.isForward()) + (edge.isInResultArea() ? " Res" : "");
    }

    public static Coordinate round(Point pt, PrecisionModel pm) {
        if (pt.isEmpty()) {
            return null;
        }
        return OverlayUtil.round(pt.getCoordinate(), pm);
    }

    public static Coordinate round(Coordinate p, PrecisionModel pm) {
        if (!OverlayUtil.isFloating(pm)) {
            Coordinate pRound = p.copy();
            pm.makePrecise(pRound);
            return pRound;
        }
        return p;
    }

    public static boolean isResultAreaConsistent(Geometry geom0, Geometry geom1, int opCode, Geometry result) {
        if (geom0 == null || geom1 == null) {
            return true;
        }
        if (result.getDimension() < 2) {
            return true;
        }
        double areaResult = result.getArea();
        double areaA = geom0.getArea();
        double areaB = geom1.getArea();
        boolean isConsistent = true;
        switch (opCode) {
            case 1: {
                isConsistent = OverlayUtil.isLess(areaResult, areaA, 0.1) && OverlayUtil.isLess(areaResult, areaB, 0.1);
                break;
            }
            case 3: {
                isConsistent = OverlayUtil.isDifferenceAreaConsistent(areaA, areaB, areaResult, 0.1);
                break;
            }
            case 4: {
                isConsistent = OverlayUtil.isLess(areaResult, areaA + areaB, 0.1);
                break;
            }
            case 2: {
                isConsistent = OverlayUtil.isLess(areaA, areaResult, 0.1) && OverlayUtil.isLess(areaB, areaResult, 0.1) && OverlayUtil.isGreater(areaResult, areaA - areaB, 0.1);
            }
        }
        return isConsistent;
    }

    private static boolean isDifferenceAreaConsistent(double areaA, double areaB, double areaResult, double tolFrac) {
        if (!OverlayUtil.isLess(areaResult, areaA, tolFrac)) {
            return false;
        }
        double areaDiffMin = areaA - areaB - tolFrac * areaA;
        return areaResult > areaDiffMin;
    }

    private static boolean isLess(double v1, double v2, double tol) {
        return v1 <= v2 * (1.0 + tol);
    }

    private static boolean isGreater(double v1, double v2, double tol) {
        return v1 >= v2 * (1.0 - tol);
    }
}

