/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset.util;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetBeen;
import org.openstreetmap.josm.plugins.changeset.util.Config;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.plugins.changeset.util.Request;
import org.openstreetmap.josm.tools.Logging;

public final class ChangesetController {
    private ChangesetController() {
    }

    public static DataSetChangesetBuilder.BoundedChangesetDataSet getChangeset(String changesetId) {
        DataSetChangesetBuilder builder = new DataSetChangesetBuilder();
        try {
            String url = "https://s3.amazonaws.com/mapbox/real-changesets/production/" + changesetId + ".json";
            String stringChangeset = Request.sendGET(url);
            if (stringChangeset == null) {
                return null;
            }
            return builder.build(stringChangeset);
        }
        catch (IOException ex) {
            Logger.getLogger(ChangesetController.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static ChangesetBeen[] getListChangeset() {
        ChangesetBeen[] changesetBeenArray;
        block18: {
            ChangesetBeen[] changesets = new ChangesetBeen[75];
            String stringChangesets = Request.sendGET(Config.getHost());
            if (stringChangesets == null) {
                return changesets;
            }
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(stringChangesets));
            try {
                JsonObject jsonObject = jsonReader.readObject();
                JsonArray jsonArray = jsonObject.getJsonArray("features");
                int i = 0;
                for (JsonValue value : jsonArray) {
                    JsonReader jsonReader2 = Json.createReader((Reader)new StringReader(value.toString()));
                    try {
                        ChangesetBeen changesetBeen = new ChangesetBeen();
                        JsonObject jsonChangeset = jsonReader2.readObject();
                        changesetBeen.setChangesetId(jsonChangeset.getInt("id"));
                        JsonObject properties = jsonChangeset.getJsonObject("properties");
                        changesetBeen.setUser(properties.getString("user"));
                        changesetBeen.setDelete(properties.getInt("delete"));
                        changesetBeen.setCreate(properties.getInt("create"));
                        changesetBeen.setModify(properties.getInt("modify"));
                        changesetBeen.setDate(properties.getString("date"));
                        changesets[i] = changesetBeen;
                        ++i;
                    }
                    finally {
                        if (jsonReader2 == null) continue;
                        jsonReader2.close();
                    }
                }
                changesetBeenArray = changesets;
                if (jsonReader == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (jsonReader != null) {
                            try {
                                jsonReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParsingException ex) {
                        Logging.error((Throwable)ex);
                        return changesets;
                    }
                }
                catch (IOException ex) {
                    Logging.error((Throwable)ex);
                    return changesets;
                }
            }
            jsonReader.close();
        }
        return changesetBeenArray;
    }
}

