/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.plugins.changeset.Changeset;
import org.openstreetmap.josm.plugins.changeset.util.CellRenderer;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetBeen;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetController;
import org.openstreetmap.josm.plugins.changeset.util.Config;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public final class ChangesetDialog
extends ToggleDialog
implements ActionListener {
    private Future<?> buttonUpdater;
    private final MapView mv;
    private final JButton jButtonNext;
    private final JButton jButtonprevious;
    private final JosmTextField jTextFieldChangesetId;
    private final ListCellRenderer<ChangesetBeen> renderer;
    private final JProgressBar progressBar;
    private final JComboBox<ChangesetBeen> jComboBox;
    private boolean flag;

    public ChangesetDialog() {
        super(I18n.tr((String)"Changeset viewer", (Object[])new Object[0]), "changeset", I18n.tr((String)"Open changeset Viewer window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Tool:changeset-viewer", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Tool:changeset-Viewer", (Object[])new Object[0])}), (int)84, (int)5010), 120);
        this.mv = MainApplication.getMap().mapView;
        this.jButtonNext = new JButton(I18n.tr((String)"Next ->", (Object[])new Object[0]));
        this.jButtonprevious = new JButton(I18n.tr((String)"<- Previous", (Object[])new Object[0]));
        this.renderer = new CellRenderer();
        this.progressBar = new JProgressBar();
        this.jComboBox = new JComboBox();
        this.flag = true;
        JPanel jPanelProjects = new JPanel(new GridBagLayout());
        jPanelProjects.setBorder(BorderFactory.createTitledBorder(""));
        JButton jButtonGetChangesets = new JButton(I18n.tr((String)"Get changeset in the area", (Object[])new Object[0]));
        jPanelProjects.add((Component)jButtonGetChangesets, GBC.eol().fill(2));
        jPanelProjects.add((Component)this.progressBar, GBC.eol().fill(2));
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(true);
        this.jButtonprevious.setEnabled(false);
        this.jButtonNext.setEnabled(false);
        jButtonGetChangesets.addActionListener(e -> {
            this.flag = false;
            Config.setPAGE(1);
            Bounds bounds = this.mv.getRealBounds();
            String bbox = bounds.getMinLon() + "," + bounds.getMinLat() + "," + bounds.getMaxLon() + "," + bounds.getMaxLat();
            Config.setBBOX(bbox);
            this.getChangesets();
            this.jButtonNext.setEnabled(true);
        });
        this.jButtonprevious.addActionListener(e -> {
            this.flag = false;
            if (Config.getPAGE() > 1) {
                Config.setPAGE(Config.getPAGE() - 1);
                this.getChangesets();
            }
        });
        this.jButtonNext.addActionListener(e -> {
            this.jButtonprevious.setEnabled(true);
            this.flag = false;
            Config.setPAGE(Config.getPAGE() + 1);
            this.getChangesets();
        });
        this.jComboBox.addActionListener(this);
        jPanelProjects.add(this.jComboBox, GBC.eol().fill(2));
        jPanelProjects.add((Component)this.jButtonprevious, GBC.std().fill(2));
        jPanelProjects.add((Component)this.jButtonNext, GBC.eol().fill(2));
        this.jTextFieldChangesetId = new JosmTextField();
        this.jTextFieldChangesetId.setHint("55006771");
        jPanelProjects.add((Component)this.jTextFieldChangesetId, GBC.eol().fill(2));
        SideButton displayChangesetButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Display changeset", (Object[])new Object[0]));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", I18n.tr((String)"Display changeset", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    ChangesetDialog.printMap(ChangesetDialog.this.jTextFieldChangesetId.getText());
                } else {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Fill a changeset id!", (Object[])new Object[0]));
                }
            }
        });
        SideButton openChangesetweb = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Open in OSM", (Object[])new Object[0]));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", I18n.tr((String)"Open in OSM", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    OpenBrowser.displayUrl((String)("https://www.openstreetmap.org/changeset/" + ChangesetDialog.this.jTextFieldChangesetId.getText()));
                } else {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Fill a changeset id!", (Object[])new Object[0]));
                }
            }
        });
        this.createLayout(jPanelProjects, false, Arrays.asList(displayChangesetButton, openChangesetweb));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ChangesetBeen ch = (ChangesetBeen)this.jComboBox.getSelectedItem();
        if (ch != null && this.flag) {
            this.jTextFieldChangesetId.setText(String.valueOf(ch.getChangesetId()));
            ChangesetDialog.printMap(String.valueOf(ch.getChangesetId()));
        }
        this.flag = true;
    }

    private synchronized void getChangesets() {
        if (this.buttonUpdater != null) {
            this.buttonUpdater.cancel(true);
        }
        this.progressBar.setVisible(true);
        this.jComboBox.setVisible(false);
        this.jComboBox.removeAllItems();
        this.jComboBox.setEnabled(false);
        this.buttonUpdater = MainApplication.worker.submit(this::asyncChangesets);
    }

    private void asyncChangesets() {
        try {
            ChangesetBeen[] changesetBeens = ChangesetController.getListChangeset();
            GuiHelper.runInEDT(() -> {
                this.jComboBox.setEnabled(true);
                for (ChangesetBeen changesetBeen : changesetBeens) {
                    if (changesetBeen == null) continue;
                    this.jComboBox.addItem(changesetBeen);
                }
                this.jComboBox.setRenderer(this.renderer);
                this.progressBar.setVisible(false);
                this.jComboBox.setVisible(true);
            });
        }
        finally {
            GuiHelper.runInEDT(() -> {
                this.progressBar.setVisible(false);
                this.jComboBox.setVisible(true);
            });
        }
    }

    public static void printMap(String changesetId) {
        DataSetChangesetBuilder.BoundedChangesetDataSet boundedDataSet = ChangesetController.getChangeset(changesetId);
        if (boundedDataSet == null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Check the right changeset Id, if it is ok, maybe the changeset was not processed yet, try again in few minutes!", (Object[])new Object[0]));
        } else {
            Changeset.work(boundedDataSet, changesetId);
        }
    }
}

