/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXcbSurfaceCreateInfoKHR
extends Struct<VkXcbSurfaceCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int CONNECTION;
    public static final int WINDOW;

    protected VkXcbSurfaceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkXcbSurfaceCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkXcbSurfaceCreateInfoKHR(address, container);
    }

    public VkXcbSurfaceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkXcbSurfaceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkXcbSurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkXcbSurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkXcbSurfaceCreateFlagsKHR")
    public int flags() {
        return VkXcbSurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="xcb_connection_t *")
    public long connection() {
        return VkXcbSurfaceCreateInfoKHR.nconnection(this.address());
    }

    @NativeType(value="xcb_window_t")
    public int window() {
        return VkXcbSurfaceCreateInfoKHR.nwindow(this.address());
    }

    public VkXcbSurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkXcbSurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR sType$Default() {
        return this.sType(1000005000);
    }

    public VkXcbSurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkXcbSurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR flags(@NativeType(value="VkXcbSurfaceCreateFlagsKHR") int value) {
        VkXcbSurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR connection(@NativeType(value="xcb_connection_t *") long value) {
        VkXcbSurfaceCreateInfoKHR.nconnection(this.address(), value);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR window(@NativeType(value="xcb_window_t") int value) {
        VkXcbSurfaceCreateInfoKHR.nwindow(this.address(), value);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR set(int sType, long pNext, int flags, long connection, int window) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.connection(connection);
        this.window(window);
        return this;
    }

    public VkXcbSurfaceCreateInfoKHR set(VkXcbSurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkXcbSurfaceCreateInfoKHR malloc() {
        return new VkXcbSurfaceCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkXcbSurfaceCreateInfoKHR calloc() {
        return new VkXcbSurfaceCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkXcbSurfaceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkXcbSurfaceCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkXcbSurfaceCreateInfoKHR create(long address) {
        return new VkXcbSurfaceCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkXcbSurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkXcbSurfaceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkXcbSurfaceCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkXcbSurfaceCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkXcbSurfaceCreateInfoKHR malloc(MemoryStack stack) {
        return new VkXcbSurfaceCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkXcbSurfaceCreateInfoKHR calloc(MemoryStack stack) {
        return new VkXcbSurfaceCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nconnection(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONNECTION);
    }

    public static int nwindow(long struct) {
        return UNSAFE.getInt(null, struct + (long)WINDOW);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nconnection(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONNECTION, value);
    }

    public static void nwindow(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WINDOW, value);
    }

    static {
        Struct.Layout layout = VkXcbSurfaceCreateInfoKHR.__struct(VkXcbSurfaceCreateInfoKHR.__member(4), VkXcbSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXcbSurfaceCreateInfoKHR.__member(4), VkXcbSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXcbSurfaceCreateInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        CONNECTION = layout.offsetof(3);
        WINDOW = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkXcbSurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkXcbSurfaceCreateInfoKHR ELEMENT_FACTORY = VkXcbSurfaceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkXcbSurfaceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkXcbSurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkXcbSurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkXcbSurfaceCreateFlagsKHR")
        public int flags() {
            return VkXcbSurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="xcb_connection_t *")
        public long connection() {
            return VkXcbSurfaceCreateInfoKHR.nconnection(this.address());
        }

        @NativeType(value="xcb_window_t")
        public int window() {
            return VkXcbSurfaceCreateInfoKHR.nwindow(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkXcbSurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000005000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkXcbSurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkXcbSurfaceCreateFlagsKHR") int value) {
            VkXcbSurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer connection(@NativeType(value="xcb_connection_t *") long value) {
            VkXcbSurfaceCreateInfoKHR.nconnection(this.address(), value);
            return this;
        }

        public Buffer window(@NativeType(value="xcb_window_t") int value) {
            VkXcbSurfaceCreateInfoKHR.nwindow(this.address(), value);
            return this;
        }
    }
}

