/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoEncodeH264NaluSliceInfoEXT;
import org.lwjgl.vulkan.video.StdVideoEncodeH264PictureInfo;

public class VkVideoEncodeH264PictureInfoEXT
extends Struct<VkVideoEncodeH264PictureInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int NALUSLICEENTRYCOUNT;
    public static final int PNALUSLICEENTRIES;
    public static final int PSTDPICTUREINFO;
    public static final int GENERATEPREFIXNALU;

    protected VkVideoEncodeH264PictureInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoEncodeH264PictureInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeH264PictureInfoEXT(address, container);
    }

    public VkVideoEncodeH264PictureInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeH264PictureInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeH264PictureInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeH264PictureInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int naluSliceEntryCount() {
        return VkVideoEncodeH264PictureInfoEXT.nnaluSliceEntryCount(this.address());
    }

    @NativeType(value="VkVideoEncodeH264NaluSliceInfoEXT const *")
    public VkVideoEncodeH264NaluSliceInfoEXT.Buffer pNaluSliceEntries() {
        return VkVideoEncodeH264PictureInfoEXT.npNaluSliceEntries(this.address());
    }

    @NativeType(value="StdVideoEncodeH264PictureInfo const *")
    public StdVideoEncodeH264PictureInfo pStdPictureInfo() {
        return VkVideoEncodeH264PictureInfoEXT.npStdPictureInfo(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean generatePrefixNalu() {
        return VkVideoEncodeH264PictureInfoEXT.ngeneratePrefixNalu(this.address()) != 0;
    }

    public VkVideoEncodeH264PictureInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeH264PictureInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT sType$Default() {
        return this.sType(1000038003);
    }

    public VkVideoEncodeH264PictureInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeH264PictureInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT pNaluSliceEntries(@NativeType(value="VkVideoEncodeH264NaluSliceInfoEXT const *") VkVideoEncodeH264NaluSliceInfoEXT.Buffer value) {
        VkVideoEncodeH264PictureInfoEXT.npNaluSliceEntries(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT pStdPictureInfo(@NativeType(value="StdVideoEncodeH264PictureInfo const *") StdVideoEncodeH264PictureInfo value) {
        VkVideoEncodeH264PictureInfoEXT.npStdPictureInfo(this.address(), value);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT generatePrefixNalu(@NativeType(value="VkBool32") boolean value) {
        VkVideoEncodeH264PictureInfoEXT.ngeneratePrefixNalu(this.address(), value ? 1 : 0);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT set(int sType, long pNext, VkVideoEncodeH264NaluSliceInfoEXT.Buffer pNaluSliceEntries, StdVideoEncodeH264PictureInfo pStdPictureInfo, boolean generatePrefixNalu) {
        this.sType(sType);
        this.pNext(pNext);
        this.pNaluSliceEntries(pNaluSliceEntries);
        this.pStdPictureInfo(pStdPictureInfo);
        this.generatePrefixNalu(generatePrefixNalu);
        return this;
    }

    public VkVideoEncodeH264PictureInfoEXT set(VkVideoEncodeH264PictureInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeH264PictureInfoEXT malloc() {
        return new VkVideoEncodeH264PictureInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoEncodeH264PictureInfoEXT calloc() {
        return new VkVideoEncodeH264PictureInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoEncodeH264PictureInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoEncodeH264PictureInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeH264PictureInfoEXT create(long address) {
        return new VkVideoEncodeH264PictureInfoEXT(address, null);
    }

    @Nullable
    public static VkVideoEncodeH264PictureInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeH264PictureInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoEncodeH264PictureInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeH264PictureInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeH264PictureInfoEXT malloc(MemoryStack stack) {
        return new VkVideoEncodeH264PictureInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeH264PictureInfoEXT calloc(MemoryStack stack) {
        return new VkVideoEncodeH264PictureInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nnaluSliceEntryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)NALUSLICEENTRYCOUNT);
    }

    public static VkVideoEncodeH264NaluSliceInfoEXT.Buffer npNaluSliceEntries(long struct) {
        return VkVideoEncodeH264NaluSliceInfoEXT.create(MemoryUtil.memGetAddress(struct + (long)PNALUSLICEENTRIES), VkVideoEncodeH264PictureInfoEXT.nnaluSliceEntryCount(struct));
    }

    public static StdVideoEncodeH264PictureInfo npStdPictureInfo(long struct) {
        return StdVideoEncodeH264PictureInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTDPICTUREINFO));
    }

    public static int ngeneratePrefixNalu(long struct) {
        return UNSAFE.getInt(null, struct + (long)GENERATEPREFIXNALU);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nnaluSliceEntryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NALUSLICEENTRYCOUNT, value);
    }

    public static void npNaluSliceEntries(long struct, VkVideoEncodeH264NaluSliceInfoEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PNALUSLICEENTRIES, value.address());
        VkVideoEncodeH264PictureInfoEXT.nnaluSliceEntryCount(struct, value.remaining());
    }

    public static void npStdPictureInfo(long struct, StdVideoEncodeH264PictureInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PSTDPICTUREINFO, value.address());
    }

    public static void ngeneratePrefixNalu(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GENERATEPREFIXNALU, value);
    }

    public static void validate(long struct) {
        int naluSliceEntryCount = VkVideoEncodeH264PictureInfoEXT.nnaluSliceEntryCount(struct);
        long pNaluSliceEntries = MemoryUtil.memGetAddress(struct + (long)PNALUSLICEENTRIES);
        Checks.check(pNaluSliceEntries);
        VkVideoEncodeH264PictureInfoEXT.validate(pNaluSliceEntries, naluSliceEntryCount, VkVideoEncodeH264NaluSliceInfoEXT.SIZEOF, VkVideoEncodeH264NaluSliceInfoEXT::validate);
        long pStdPictureInfo = MemoryUtil.memGetAddress(struct + (long)PSTDPICTUREINFO);
        Checks.check(pStdPictureInfo);
        StdVideoEncodeH264PictureInfo.validate(pStdPictureInfo);
    }

    static {
        Struct.Layout layout = VkVideoEncodeH264PictureInfoEXT.__struct(VkVideoEncodeH264PictureInfoEXT.__member(4), VkVideoEncodeH264PictureInfoEXT.__member(POINTER_SIZE), VkVideoEncodeH264PictureInfoEXT.__member(4), VkVideoEncodeH264PictureInfoEXT.__member(POINTER_SIZE), VkVideoEncodeH264PictureInfoEXT.__member(POINTER_SIZE), VkVideoEncodeH264PictureInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        NALUSLICEENTRYCOUNT = layout.offsetof(2);
        PNALUSLICEENTRIES = layout.offsetof(3);
        PSTDPICTUREINFO = layout.offsetof(4);
        GENERATEPREFIXNALU = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeH264PictureInfoEXT, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeH264PictureInfoEXT ELEMENT_FACTORY = VkVideoEncodeH264PictureInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoEncodeH264PictureInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeH264PictureInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeH264PictureInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int naluSliceEntryCount() {
            return VkVideoEncodeH264PictureInfoEXT.nnaluSliceEntryCount(this.address());
        }

        @NativeType(value="VkVideoEncodeH264NaluSliceInfoEXT const *")
        public VkVideoEncodeH264NaluSliceInfoEXT.Buffer pNaluSliceEntries() {
            return VkVideoEncodeH264PictureInfoEXT.npNaluSliceEntries(this.address());
        }

        @NativeType(value="StdVideoEncodeH264PictureInfo const *")
        public StdVideoEncodeH264PictureInfo pStdPictureInfo() {
            return VkVideoEncodeH264PictureInfoEXT.npStdPictureInfo(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean generatePrefixNalu() {
            return VkVideoEncodeH264PictureInfoEXT.ngeneratePrefixNalu(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeH264PictureInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000038003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeH264PictureInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNaluSliceEntries(@NativeType(value="VkVideoEncodeH264NaluSliceInfoEXT const *") VkVideoEncodeH264NaluSliceInfoEXT.Buffer value) {
            VkVideoEncodeH264PictureInfoEXT.npNaluSliceEntries(this.address(), value);
            return this;
        }

        public Buffer pStdPictureInfo(@NativeType(value="StdVideoEncodeH264PictureInfo const *") StdVideoEncodeH264PictureInfo value) {
            VkVideoEncodeH264PictureInfoEXT.npStdPictureInfo(this.address(), value);
            return this;
        }

        public Buffer generatePrefixNalu(@NativeType(value="VkBool32") boolean value) {
            VkVideoEncodeH264PictureInfoEXT.ngeneratePrefixNalu(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

