/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationFlagsEXT
extends Struct<VkValidationFlagsEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DISABLEDVALIDATIONCHECKCOUNT;
    public static final int PDISABLEDVALIDATIONCHECKS;

    protected VkValidationFlagsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkValidationFlagsEXT create(long address, @Nullable ByteBuffer container) {
        return new VkValidationFlagsEXT(address, container);
    }

    public VkValidationFlagsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkValidationFlagsEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkValidationFlagsEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkValidationFlagsEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int disabledValidationCheckCount() {
        return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
    }

    @NativeType(value="VkValidationCheckEXT const *")
    public IntBuffer pDisabledValidationChecks() {
        return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
    }

    public VkValidationFlagsEXT sType(@NativeType(value="VkStructureType") int value) {
        VkValidationFlagsEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT sType$Default() {
        return this.sType(1000061000);
    }

    public VkValidationFlagsEXT pNext(@NativeType(value="void const *") long value) {
        VkValidationFlagsEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT pDisabledValidationChecks(@NativeType(value="VkValidationCheckEXT const *") IntBuffer value) {
        VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
        return this;
    }

    public VkValidationFlagsEXT set(int sType, long pNext, IntBuffer pDisabledValidationChecks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pDisabledValidationChecks(pDisabledValidationChecks);
        return this;
    }

    public VkValidationFlagsEXT set(VkValidationFlagsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkValidationFlagsEXT malloc() {
        return new VkValidationFlagsEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkValidationFlagsEXT calloc() {
        return new VkValidationFlagsEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkValidationFlagsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkValidationFlagsEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkValidationFlagsEXT create(long address) {
        return new VkValidationFlagsEXT(address, null);
    }

    @Nullable
    public static VkValidationFlagsEXT createSafe(long address) {
        return address == 0L ? null : new VkValidationFlagsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkValidationFlagsEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkValidationFlagsEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkValidationFlagsEXT mallocStack() {
        return VkValidationFlagsEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationFlagsEXT callocStack() {
        return VkValidationFlagsEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationFlagsEXT mallocStack(MemoryStack stack) {
        return VkValidationFlagsEXT.malloc(stack);
    }

    @Deprecated
    public static VkValidationFlagsEXT callocStack(MemoryStack stack) {
        return VkValidationFlagsEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkValidationFlagsEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkValidationFlagsEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkValidationFlagsEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkValidationFlagsEXT.calloc(capacity, stack);
    }

    public static VkValidationFlagsEXT malloc(MemoryStack stack) {
        return new VkValidationFlagsEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkValidationFlagsEXT calloc(MemoryStack stack) {
        return new VkValidationFlagsEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ndisabledValidationCheckCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISABLEDVALIDATIONCHECKCOUNT);
    }

    public static IntBuffer npDisabledValidationChecks(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONCHECKS), VkValidationFlagsEXT.ndisabledValidationCheckCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndisabledValidationCheckCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISABLEDVALIDATIONCHECKCOUNT, value);
    }

    public static void npDisabledValidationChecks(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDISABLEDVALIDATIONCHECKS, MemoryUtil.memAddress(value));
        VkValidationFlagsEXT.ndisabledValidationCheckCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDISABLEDVALIDATIONCHECKS));
    }

    static {
        Struct.Layout layout = VkValidationFlagsEXT.__struct(VkValidationFlagsEXT.__member(4), VkValidationFlagsEXT.__member(POINTER_SIZE), VkValidationFlagsEXT.__member(4), VkValidationFlagsEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DISABLEDVALIDATIONCHECKCOUNT = layout.offsetof(2);
        PDISABLEDVALIDATIONCHECKS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkValidationFlagsEXT, Buffer>
    implements NativeResource {
        private static final VkValidationFlagsEXT ELEMENT_FACTORY = VkValidationFlagsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkValidationFlagsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkValidationFlagsEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkValidationFlagsEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int disabledValidationCheckCount() {
            return VkValidationFlagsEXT.ndisabledValidationCheckCount(this.address());
        }

        @NativeType(value="VkValidationCheckEXT const *")
        public IntBuffer pDisabledValidationChecks() {
            return VkValidationFlagsEXT.npDisabledValidationChecks(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkValidationFlagsEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000061000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkValidationFlagsEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pDisabledValidationChecks(@NativeType(value="VkValidationCheckEXT const *") IntBuffer value) {
            VkValidationFlagsEXT.npDisabledValidationChecks(this.address(), value);
            return this;
        }
    }
}

