/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAmigoProfilingSubmitInfoSEC;
import org.lwjgl.vulkan.VkD3D12FenceSubmitInfoKHR;
import org.lwjgl.vulkan.VkDeviceGroupSubmitInfo;
import org.lwjgl.vulkan.VkDeviceGroupSubmitInfoKHR;
import org.lwjgl.vulkan.VkFrameBoundaryEXT;
import org.lwjgl.vulkan.VkPerformanceQuerySubmitInfoKHR;
import org.lwjgl.vulkan.VkProtectedSubmitInfo;
import org.lwjgl.vulkan.VkTimelineSemaphoreSubmitInfo;
import org.lwjgl.vulkan.VkTimelineSemaphoreSubmitInfoKHR;
import org.lwjgl.vulkan.VkWin32KeyedMutexAcquireReleaseInfoKHR;
import org.lwjgl.vulkan.VkWin32KeyedMutexAcquireReleaseInfoNV;

public class VkSubmitInfo
extends Struct<VkSubmitInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHORES;
    public static final int PWAITDSTSTAGEMASK;
    public static final int COMMANDBUFFERCOUNT;
    public static final int PCOMMANDBUFFERS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHORES;

    protected VkSubmitInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubmitInfo create(long address, @Nullable ByteBuffer container) {
        return new VkSubmitInfo(address, container);
    }

    public VkSubmitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubmitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubmitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubmitInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkSubmitInfo.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pWaitSemaphores() {
        return VkSubmitInfo.npWaitSemaphores(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineStageFlags const *")
    public IntBuffer pWaitDstStageMask() {
        return VkSubmitInfo.npWaitDstStageMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int commandBufferCount() {
        return VkSubmitInfo.ncommandBufferCount(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBuffer const *")
    public PointerBuffer pCommandBuffers() {
        return VkSubmitInfo.npCommandBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreCount() {
        return VkSubmitInfo.nsignalSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSemaphore const *")
    public LongBuffer pSignalSemaphores() {
        return VkSubmitInfo.npSignalSemaphores(this.address());
    }

    public VkSubmitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkSubmitInfo sType$Default() {
        return this.sType(4);
    }

    public VkSubmitInfo pNext(@NativeType(value="void const *") long value) {
        VkSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkSubmitInfo pNext(VkAmigoProfilingSubmitInfoSEC value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkD3D12FenceSubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkDeviceGroupSubmitInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkDeviceGroupSubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkFrameBoundaryEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkPerformanceQuerySubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkProtectedSubmitInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkTimelineSemaphoreSubmitInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkTimelineSemaphoreSubmitInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkWin32KeyedMutexAcquireReleaseInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo pNext(VkWin32KeyedMutexAcquireReleaseInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubmitInfo waitSemaphoreCount(@NativeType(value="uint32_t") int value) {
        VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkSubmitInfo.npWaitSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo pWaitDstStageMask(@Nullable @NativeType(value="VkPipelineStageFlags const *") IntBuffer value) {
        VkSubmitInfo.npWaitDstStageMask(this.address(), value);
        return this;
    }

    public VkSubmitInfo pCommandBuffers(@Nullable @NativeType(value="VkCommandBuffer const *") PointerBuffer value) {
        VkSubmitInfo.npCommandBuffers(this.address(), value);
        return this;
    }

    public VkSubmitInfo pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkSubmitInfo.npSignalSemaphores(this.address(), value);
        return this;
    }

    public VkSubmitInfo set(int sType, long pNext, int waitSemaphoreCount, @Nullable LongBuffer pWaitSemaphores, @Nullable IntBuffer pWaitDstStageMask, @Nullable PointerBuffer pCommandBuffers, @Nullable LongBuffer pSignalSemaphores) {
        this.sType(sType);
        this.pNext(pNext);
        this.waitSemaphoreCount(waitSemaphoreCount);
        this.pWaitSemaphores(pWaitSemaphores);
        this.pWaitDstStageMask(pWaitDstStageMask);
        this.pCommandBuffers(pCommandBuffers);
        this.pSignalSemaphores(pSignalSemaphores);
        return this;
    }

    public VkSubmitInfo set(VkSubmitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubmitInfo malloc() {
        return new VkSubmitInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubmitInfo calloc() {
        return new VkSubmitInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubmitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubmitInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkSubmitInfo create(long address) {
        return new VkSubmitInfo(address, null);
    }

    @Nullable
    public static VkSubmitInfo createSafe(long address) {
        return address == 0L ? null : new VkSubmitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubmitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubmitInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubmitInfo mallocStack() {
        return VkSubmitInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubmitInfo callocStack() {
        return VkSubmitInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubmitInfo mallocStack(MemoryStack stack) {
        return VkSubmitInfo.malloc(stack);
    }

    @Deprecated
    public static VkSubmitInfo callocStack(MemoryStack stack) {
        return VkSubmitInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubmitInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubmitInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubmitInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubmitInfo.calloc(capacity, stack);
    }

    public static VkSubmitInfo malloc(MemoryStack stack) {
        return new VkSubmitInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubmitInfo calloc(MemoryStack stack) {
        return new VkSubmitInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nwaitSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npWaitSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES), VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    @Nullable
    public static IntBuffer npWaitDstStageMask(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PWAITDSTSTAGEMASK), VkSubmitInfo.nwaitSemaphoreCount(struct));
    }

    public static int ncommandBufferCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMANDBUFFERCOUNT);
    }

    @Nullable
    public static PointerBuffer npCommandBuffers(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERS), VkSubmitInfo.ncommandBufferCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIGNALSEMAPHORECOUNT);
    }

    @Nullable
    public static LongBuffer npSignalSemaphores(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES), VkSubmitInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITSEMAPHORES, MemoryUtil.memAddressSafe(value));
    }

    public static void npWaitDstStageMask(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PWAITDSTSTAGEMASK, MemoryUtil.memAddressSafe(value));
    }

    public static void ncommandBufferCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMMANDBUFFERCOUNT, value);
    }

    public static void npCommandBuffers(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOMMANDBUFFERS, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo.ncommandBufferCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphores(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSIGNALSEMAPHORES, MemoryUtil.memAddressSafe(value));
        VkSubmitInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubmitInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PWAITSEMAPHORES));
        }
        if (VkSubmitInfo.ncommandBufferCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOMMANDBUFFERS));
        }
        if (VkSubmitInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PSIGNALSEMAPHORES));
        }
    }

    static {
        Struct.Layout layout = VkSubmitInfo.__struct(VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE), VkSubmitInfo.__member(4), VkSubmitInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHORES = layout.offsetof(3);
        PWAITDSTSTAGEMASK = layout.offsetof(4);
        COMMANDBUFFERCOUNT = layout.offsetof(5);
        PCOMMANDBUFFERS = layout.offsetof(6);
        SIGNALSEMAPHORECOUNT = layout.offsetof(7);
        PSIGNALSEMAPHORES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkSubmitInfo, Buffer>
    implements NativeResource {
        private static final VkSubmitInfo ELEMENT_FACTORY = VkSubmitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubmitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubmitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubmitInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkSubmitInfo.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pWaitSemaphores() {
            return VkSubmitInfo.npWaitSemaphores(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineStageFlags const *")
        public IntBuffer pWaitDstStageMask() {
            return VkSubmitInfo.npWaitDstStageMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int commandBufferCount() {
            return VkSubmitInfo.ncommandBufferCount(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBuffer const *")
        public PointerBuffer pCommandBuffers() {
            return VkSubmitInfo.npCommandBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreCount() {
            return VkSubmitInfo.nsignalSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSemaphore const *")
        public LongBuffer pSignalSemaphores() {
            return VkSubmitInfo.npSignalSemaphores(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(4);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkAmigoProfilingSubmitInfoSEC value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkD3D12FenceSubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupSubmitInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupSubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkFrameBoundaryEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPerformanceQuerySubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkProtectedSubmitInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkTimelineSemaphoreSubmitInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkTimelineSemaphoreSubmitInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWin32KeyedMutexAcquireReleaseInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWin32KeyedMutexAcquireReleaseInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer waitSemaphoreCount(@NativeType(value="uint32_t") int value) {
            VkSubmitInfo.nwaitSemaphoreCount(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkSubmitInfo.npWaitSemaphores(this.address(), value);
            return this;
        }

        public Buffer pWaitDstStageMask(@Nullable @NativeType(value="VkPipelineStageFlags const *") IntBuffer value) {
            VkSubmitInfo.npWaitDstStageMask(this.address(), value);
            return this;
        }

        public Buffer pCommandBuffers(@Nullable @NativeType(value="VkCommandBuffer const *") PointerBuffer value) {
            VkSubmitInfo.npCommandBuffers(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphores(@Nullable @NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkSubmitInfo.npSignalSemaphores(this.address(), value);
            return this;
        }
    }
}

