/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineCreateFlags2CreateInfoKHR;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfo;
import org.lwjgl.vulkan.VkPipelineCreationFeedbackCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkRayTracingShaderGroupCreateInfoNV;

public class VkRayTracingPipelineCreateInfoNV
extends Struct<VkRayTracingPipelineCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int GROUPCOUNT;
    public static final int PGROUPS;
    public static final int MAXRECURSIONDEPTH;
    public static final int LAYOUT;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    protected VkRayTracingPipelineCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRayTracingPipelineCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkRayTracingPipelineCreateInfoNV(address, container);
    }

    public VkRayTracingPipelineCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRayTracingPipelineCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRayTracingPipelineCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRayTracingPipelineCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkPipelineCreateFlags")
    public int flags() {
        return VkRayTracingPipelineCreateInfoNV.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int stageCount() {
        return VkRayTracingPipelineCreateInfoNV.nstageCount(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateInfo const *")
    public VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkRayTracingPipelineCreateInfoNV.npStages(this.address());
    }

    @NativeType(value="uint32_t")
    public int groupCount() {
        return VkRayTracingPipelineCreateInfoNV.ngroupCount(this.address());
    }

    @NativeType(value="VkRayTracingShaderGroupCreateInfoNV const *")
    public VkRayTracingShaderGroupCreateInfoNV.Buffer pGroups() {
        return VkRayTracingPipelineCreateInfoNV.npGroups(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxRecursionDepth() {
        return VkRayTracingPipelineCreateInfoNV.nmaxRecursionDepth(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkRayTracingPipelineCreateInfoNV.nlayout(this.address());
    }

    @NativeType(value="VkPipeline")
    public long basePipelineHandle() {
        return VkRayTracingPipelineCreateInfoNV.nbasePipelineHandle(this.address());
    }

    @NativeType(value="int32_t")
    public int basePipelineIndex() {
        return VkRayTracingPipelineCreateInfoNV.nbasePipelineIndex(this.address());
    }

    public VkRayTracingPipelineCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkRayTracingPipelineCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV sType$Default() {
        return this.sType(1000165000);
    }

    public VkRayTracingPipelineCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkRayTracingPipelineCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoNV pNext(VkPipelineCreationFeedbackCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoNV pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRayTracingPipelineCreateInfoNV flags(@NativeType(value="VkPipelineCreateFlags") int value) {
        VkRayTracingPipelineCreateInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
        VkRayTracingPipelineCreateInfoNV.npStages(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV pGroups(@NativeType(value="VkRayTracingShaderGroupCreateInfoNV const *") VkRayTracingShaderGroupCreateInfoNV.Buffer value) {
        VkRayTracingPipelineCreateInfoNV.npGroups(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV maxRecursionDepth(@NativeType(value="uint32_t") int value) {
        VkRayTracingPipelineCreateInfoNV.nmaxRecursionDepth(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV layout(@NativeType(value="VkPipelineLayout") long value) {
        VkRayTracingPipelineCreateInfoNV.nlayout(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV basePipelineHandle(@NativeType(value="VkPipeline") long value) {
        VkRayTracingPipelineCreateInfoNV.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV basePipelineIndex(@NativeType(value="int32_t") int value) {
        VkRayTracingPipelineCreateInfoNV.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV set(int sType, long pNext, int flags, VkPipelineShaderStageCreateInfo.Buffer pStages, VkRayTracingShaderGroupCreateInfoNV.Buffer pGroups, int maxRecursionDepth, long layout, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pStages(pStages);
        this.pGroups(pGroups);
        this.maxRecursionDepth(maxRecursionDepth);
        this.layout(layout);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkRayTracingPipelineCreateInfoNV set(VkRayTracingPipelineCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRayTracingPipelineCreateInfoNV malloc() {
        return new VkRayTracingPipelineCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoNV calloc() {
        return new VkRayTracingPipelineCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRayTracingPipelineCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkRayTracingPipelineCreateInfoNV create(long address) {
        return new VkRayTracingPipelineCreateInfoNV(address, null);
    }

    @Nullable
    public static VkRayTracingPipelineCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkRayTracingPipelineCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRayTracingPipelineCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRayTracingPipelineCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkRayTracingPipelineCreateInfoNV mallocStack() {
        return VkRayTracingPipelineCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRayTracingPipelineCreateInfoNV callocStack() {
        return VkRayTracingPipelineCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRayTracingPipelineCreateInfoNV mallocStack(MemoryStack stack) {
        return VkRayTracingPipelineCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkRayTracingPipelineCreateInfoNV callocStack(MemoryStack stack) {
        return VkRayTracingPipelineCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRayTracingPipelineCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRayTracingPipelineCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRayTracingPipelineCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRayTracingPipelineCreateInfoNV.calloc(capacity, stack);
    }

    public static VkRayTracingPipelineCreateInfoNV malloc(MemoryStack stack) {
        return new VkRayTracingPipelineCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRayTracingPipelineCreateInfoNV calloc(MemoryStack stack) {
        return new VkRayTracingPipelineCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nstageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGECOUNT);
    }

    public static VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTAGES), VkRayTracingPipelineCreateInfoNV.nstageCount(struct));
    }

    public static int ngroupCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GROUPCOUNT);
    }

    public static VkRayTracingShaderGroupCreateInfoNV.Buffer npGroups(long struct) {
        return VkRayTracingShaderGroupCreateInfoNV.create(MemoryUtil.memGetAddress(struct + (long)PGROUPS), VkRayTracingPipelineCreateInfoNV.ngroupCount(struct));
    }

    public static int nmaxRecursionDepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXRECURSIONDEPTH);
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static long nbasePipelineHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nstageCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGECOUNT, value);
    }

    public static void npStages(long struct, VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTAGES, value.address());
        VkRayTracingPipelineCreateInfoNV.nstageCount(struct, value.remaining());
    }

    public static void ngroupCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GROUPCOUNT, value);
    }

    public static void npGroups(long struct, VkRayTracingShaderGroupCreateInfoNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PGROUPS, value.address());
        VkRayTracingPipelineCreateInfoNV.ngroupCount(struct, value.remaining());
    }

    public static void nmaxRecursionDepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXRECURSIONDEPTH, value);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        int stageCount = VkRayTracingPipelineCreateInfoNV.nstageCount(struct);
        long pStages = MemoryUtil.memGetAddress(struct + (long)PSTAGES);
        Checks.check(pStages);
        VkRayTracingPipelineCreateInfoNV.validate(pStages, stageCount, VkPipelineShaderStageCreateInfo.SIZEOF, VkPipelineShaderStageCreateInfo::validate);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PGROUPS));
    }

    static {
        Struct.Layout layout = VkRayTracingPipelineCreateInfoNV.__struct(VkRayTracingPipelineCreateInfoNV.__member(4), VkRayTracingPipelineCreateInfoNV.__member(POINTER_SIZE), VkRayTracingPipelineCreateInfoNV.__member(4), VkRayTracingPipelineCreateInfoNV.__member(4), VkRayTracingPipelineCreateInfoNV.__member(POINTER_SIZE), VkRayTracingPipelineCreateInfoNV.__member(4), VkRayTracingPipelineCreateInfoNV.__member(POINTER_SIZE), VkRayTracingPipelineCreateInfoNV.__member(4), VkRayTracingPipelineCreateInfoNV.__member(8), VkRayTracingPipelineCreateInfoNV.__member(8), VkRayTracingPipelineCreateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGECOUNT = layout.offsetof(3);
        PSTAGES = layout.offsetof(4);
        GROUPCOUNT = layout.offsetof(5);
        PGROUPS = layout.offsetof(6);
        MAXRECURSIONDEPTH = layout.offsetof(7);
        LAYOUT = layout.offsetof(8);
        BASEPIPELINEHANDLE = layout.offsetof(9);
        BASEPIPELINEINDEX = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkRayTracingPipelineCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkRayTracingPipelineCreateInfoNV ELEMENT_FACTORY = VkRayTracingPipelineCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRayTracingPipelineCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRayTracingPipelineCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRayTracingPipelineCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkPipelineCreateFlags")
        public int flags() {
            return VkRayTracingPipelineCreateInfoNV.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int stageCount() {
            return VkRayTracingPipelineCreateInfoNV.nstageCount(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateInfo const *")
        public VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkRayTracingPipelineCreateInfoNV.npStages(this.address());
        }

        @NativeType(value="uint32_t")
        public int groupCount() {
            return VkRayTracingPipelineCreateInfoNV.ngroupCount(this.address());
        }

        @NativeType(value="VkRayTracingShaderGroupCreateInfoNV const *")
        public VkRayTracingShaderGroupCreateInfoNV.Buffer pGroups() {
            return VkRayTracingPipelineCreateInfoNV.npGroups(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxRecursionDepth() {
            return VkRayTracingPipelineCreateInfoNV.nmaxRecursionDepth(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkRayTracingPipelineCreateInfoNV.nlayout(this.address());
        }

        @NativeType(value="VkPipeline")
        public long basePipelineHandle() {
            return VkRayTracingPipelineCreateInfoNV.nbasePipelineHandle(this.address());
        }

        @NativeType(value="int32_t")
        public int basePipelineIndex() {
            return VkRayTracingPipelineCreateInfoNV.nbasePipelineIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRayTracingPipelineCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000165000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRayTracingPipelineCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineCreateFlags2CreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineCreationFeedbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineCreateFlags") int value) {
            VkRayTracingPipelineCreateInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer pStages(@NativeType(value="VkPipelineShaderStageCreateInfo const *") VkPipelineShaderStageCreateInfo.Buffer value) {
            VkRayTracingPipelineCreateInfoNV.npStages(this.address(), value);
            return this;
        }

        public Buffer pGroups(@NativeType(value="VkRayTracingShaderGroupCreateInfoNV const *") VkRayTracingShaderGroupCreateInfoNV.Buffer value) {
            VkRayTracingPipelineCreateInfoNV.npGroups(this.address(), value);
            return this;
        }

        public Buffer maxRecursionDepth(@NativeType(value="uint32_t") int value) {
            VkRayTracingPipelineCreateInfoNV.nmaxRecursionDepth(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkRayTracingPipelineCreateInfoNV.nlayout(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(@NativeType(value="VkPipeline") long value) {
            VkRayTracingPipelineCreateInfoNV.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(@NativeType(value="int32_t") int value) {
            VkRayTracingPipelineCreateInfoNV.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

