/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRectLayerKHR;

public class VkPresentRegionKHR
extends Struct<VkPresentRegionKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECTANGLECOUNT;
    public static final int PRECTANGLES;

    protected VkPresentRegionKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPresentRegionKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPresentRegionKHR(address, container);
    }

    public VkPresentRegionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPresentRegionKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int rectangleCount() {
        return VkPresentRegionKHR.nrectangleCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRectLayerKHR const *")
    public VkRectLayerKHR.Buffer pRectangles() {
        return VkPresentRegionKHR.npRectangles(this.address());
    }

    public VkPresentRegionKHR rectangleCount(@NativeType(value="uint32_t") int value) {
        VkPresentRegionKHR.nrectangleCount(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
        VkPresentRegionKHR.npRectangles(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR set(int rectangleCount, @Nullable VkRectLayerKHR.Buffer pRectangles) {
        this.rectangleCount(rectangleCount);
        this.pRectangles(pRectangles);
        return this;
    }

    public VkPresentRegionKHR set(VkPresentRegionKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPresentRegionKHR malloc() {
        return new VkPresentRegionKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPresentRegionKHR calloc() {
        return new VkPresentRegionKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPresentRegionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPresentRegionKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPresentRegionKHR create(long address) {
        return new VkPresentRegionKHR(address, null);
    }

    @Nullable
    public static VkPresentRegionKHR createSafe(long address) {
        return address == 0L ? null : new VkPresentRegionKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPresentRegionKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPresentRegionKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPresentRegionKHR mallocStack() {
        return VkPresentRegionKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentRegionKHR callocStack() {
        return VkPresentRegionKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentRegionKHR mallocStack(MemoryStack stack) {
        return VkPresentRegionKHR.malloc(stack);
    }

    @Deprecated
    public static VkPresentRegionKHR callocStack(MemoryStack stack) {
        return VkPresentRegionKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPresentRegionKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPresentRegionKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.calloc(capacity, stack);
    }

    public static VkPresentRegionKHR malloc(MemoryStack stack) {
        return new VkPresentRegionKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPresentRegionKHR calloc(MemoryStack stack) {
        return new VkPresentRegionKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nrectangleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)RECTANGLECOUNT);
    }

    @Nullable
    public static VkRectLayerKHR.Buffer npRectangles(long struct) {
        return VkRectLayerKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PRECTANGLES), VkPresentRegionKHR.nrectangleCount(struct));
    }

    public static void nrectangleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RECTANGLECOUNT, value);
    }

    public static void npRectangles(long struct, @Nullable VkRectLayerKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRECTANGLES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPresentRegionKHR.nrectangleCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPresentRegionKHR.__struct(VkPresentRegionKHR.__member(4), VkPresentRegionKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECTANGLECOUNT = layout.offsetof(0);
        PRECTANGLES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPresentRegionKHR, Buffer>
    implements NativeResource {
        private static final VkPresentRegionKHR ELEMENT_FACTORY = VkPresentRegionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPresentRegionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int rectangleCount() {
            return VkPresentRegionKHR.nrectangleCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRectLayerKHR const *")
        public VkRectLayerKHR.Buffer pRectangles() {
            return VkPresentRegionKHR.npRectangles(this.address());
        }

        public Buffer rectangleCount(@NativeType(value="uint32_t") int value) {
            VkPresentRegionKHR.nrectangleCount(this.address(), value);
            return this;
        }

        public Buffer pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
            VkPresentRegionKHR.npRectangles(this.address(), value);
            return this;
        }
    }
}

