/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDevicePrivateDataFeatures
extends Struct<VkPhysicalDevicePrivateDataFeatures>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRIVATEDATA;

    protected VkPhysicalDevicePrivateDataFeatures(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDevicePrivateDataFeatures create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDevicePrivateDataFeatures(address, container);
    }

    public VkPhysicalDevicePrivateDataFeatures(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDevicePrivateDataFeatures.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDevicePrivateDataFeatures.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDevicePrivateDataFeatures.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean privateData() {
        return VkPhysicalDevicePrivateDataFeatures.nprivateData(this.address()) != 0;
    }

    public VkPhysicalDevicePrivateDataFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDevicePrivateDataFeatures.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDevicePrivateDataFeatures sType$Default() {
        return this.sType(1000295000);
    }

    public VkPhysicalDevicePrivateDataFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDevicePrivateDataFeatures.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDevicePrivateDataFeatures privateData(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDevicePrivateDataFeatures.nprivateData(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDevicePrivateDataFeatures set(int sType, long pNext, boolean privateData) {
        this.sType(sType);
        this.pNext(pNext);
        this.privateData(privateData);
        return this;
    }

    public VkPhysicalDevicePrivateDataFeatures set(VkPhysicalDevicePrivateDataFeatures src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDevicePrivateDataFeatures malloc() {
        return new VkPhysicalDevicePrivateDataFeatures(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDevicePrivateDataFeatures calloc() {
        return new VkPhysicalDevicePrivateDataFeatures(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDevicePrivateDataFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDevicePrivateDataFeatures(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDevicePrivateDataFeatures create(long address) {
        return new VkPhysicalDevicePrivateDataFeatures(address, null);
    }

    @Nullable
    public static VkPhysicalDevicePrivateDataFeatures createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDevicePrivateDataFeatures(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDevicePrivateDataFeatures.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDevicePrivateDataFeatures.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPhysicalDevicePrivateDataFeatures malloc(MemoryStack stack) {
        return new VkPhysicalDevicePrivateDataFeatures(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDevicePrivateDataFeatures calloc(MemoryStack stack) {
        return new VkPhysicalDevicePrivateDataFeatures(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprivateData(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIVATEDATA);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprivateData(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIVATEDATA, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDevicePrivateDataFeatures.__struct(VkPhysicalDevicePrivateDataFeatures.__member(4), VkPhysicalDevicePrivateDataFeatures.__member(POINTER_SIZE), VkPhysicalDevicePrivateDataFeatures.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRIVATEDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDevicePrivateDataFeatures, Buffer>
    implements NativeResource {
        private static final VkPhysicalDevicePrivateDataFeatures ELEMENT_FACTORY = VkPhysicalDevicePrivateDataFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDevicePrivateDataFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDevicePrivateDataFeatures.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDevicePrivateDataFeatures.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean privateData() {
            return VkPhysicalDevicePrivateDataFeatures.nprivateData(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDevicePrivateDataFeatures.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000295000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDevicePrivateDataFeatures.npNext(this.address(), value);
            return this;
        }

        public Buffer privateData(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDevicePrivateDataFeatures.nprivateData(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

