/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceHostImageCopyPropertiesEXT
extends Struct<VkPhysicalDeviceHostImageCopyPropertiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COPYSRCLAYOUTCOUNT;
    public static final int PCOPYSRCLAYOUTS;
    public static final int COPYDSTLAYOUTCOUNT;
    public static final int PCOPYDSTLAYOUTS;
    public static final int OPTIMALTILINGLAYOUTUUID;
    public static final int IDENTICALMEMORYTYPEREQUIREMENTS;

    protected VkPhysicalDeviceHostImageCopyPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceHostImageCopyPropertiesEXT create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(address, container);
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceHostImageCopyPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int copySrcLayoutCount() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageLayout *")
    public IntBuffer pCopySrcLayouts() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopySrcLayouts(this.address());
    }

    @NativeType(value="uint32_t")
    public int copyDstLayoutCount() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageLayout *")
    public IntBuffer pCopyDstLayouts() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopyDstLayouts(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer optimalTilingLayoutUUID() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte optimalTilingLayoutUUID(int index) {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), index);
    }

    @NativeType(value="VkBool32")
    public boolean identicalMemoryTypeRequirements() {
        return VkPhysicalDeviceHostImageCopyPropertiesEXT.nidenticalMemoryTypeRequirements(this.address()) != 0;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT sType$Default() {
        return this.sType(1000270001);
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT copySrcLayoutCount(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT pCopySrcLayouts(@Nullable @NativeType(value="VkImageLayout *") IntBuffer value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopySrcLayouts(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT copyDstLayoutCount(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT pCopyDstLayouts(@Nullable @NativeType(value="VkImageLayout *") IntBuffer value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopyDstLayouts(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT optimalTilingLayoutUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT optimalTilingLayoutUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), index, value);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT identicalMemoryTypeRequirements(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceHostImageCopyPropertiesEXT.nidenticalMemoryTypeRequirements(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT set(int sType, long pNext, int copySrcLayoutCount, @Nullable IntBuffer pCopySrcLayouts, int copyDstLayoutCount, @Nullable IntBuffer pCopyDstLayouts, ByteBuffer optimalTilingLayoutUUID, boolean identicalMemoryTypeRequirements) {
        this.sType(sType);
        this.pNext(pNext);
        this.copySrcLayoutCount(copySrcLayoutCount);
        this.pCopySrcLayouts(pCopySrcLayouts);
        this.copyDstLayoutCount(copyDstLayoutCount);
        this.pCopyDstLayouts(pCopyDstLayouts);
        this.optimalTilingLayoutUUID(optimalTilingLayoutUUID);
        this.identicalMemoryTypeRequirements(identicalMemoryTypeRequirements);
        return this;
    }

    public VkPhysicalDeviceHostImageCopyPropertiesEXT set(VkPhysicalDeviceHostImageCopyPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT malloc() {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT calloc() {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT create(long address) {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceHostImageCopyPropertiesEXT createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceHostImageCopyPropertiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceHostImageCopyPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceHostImageCopyPropertiesEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT malloc(MemoryStack stack) {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceHostImageCopyPropertiesEXT calloc(MemoryStack stack) {
        return new VkPhysicalDeviceHostImageCopyPropertiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncopySrcLayoutCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COPYSRCLAYOUTCOUNT);
    }

    @Nullable
    public static IntBuffer npCopySrcLayouts(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOPYSRCLAYOUTS), VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(struct));
    }

    public static int ncopyDstLayoutCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COPYDSTLAYOUTCOUNT);
    }

    @Nullable
    public static IntBuffer npCopyDstLayouts(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOPYDSTLAYOUTS), VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(struct));
    }

    public static ByteBuffer noptimalTilingLayoutUUID(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)OPTIMALTILINGLAYOUTUUID, 16);
    }

    public static byte noptimalTilingLayoutUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)OPTIMALTILINGLAYOUTUUID + Checks.check(index, 16) * 1L);
    }

    public static int nidenticalMemoryTypeRequirements(long struct) {
        return UNSAFE.getInt(null, struct + (long)IDENTICALMEMORYTYPEREQUIREMENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncopySrcLayoutCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COPYSRCLAYOUTCOUNT, value);
    }

    public static void npCopySrcLayouts(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOPYSRCLAYOUTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(struct, value.remaining());
        }
    }

    public static void ncopyDstLayoutCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COPYDSTLAYOUTCOUNT, value);
    }

    public static void npCopyDstLayouts(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOPYDSTLAYOUTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(struct, value.remaining());
        }
    }

    public static void noptimalTilingLayoutUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)OPTIMALTILINGLAYOUTUUID, value.remaining() * 1);
    }

    public static void noptimalTilingLayoutUUID(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)OPTIMALTILINGLAYOUTUUID + Checks.check(index, 16) * 1L, value);
    }

    public static void nidenticalMemoryTypeRequirements(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IDENTICALMEMORYTYPEREQUIREMENTS, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceHostImageCopyPropertiesEXT.__struct(VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(4), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(POINTER_SIZE), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(4), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(POINTER_SIZE), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(4), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(POINTER_SIZE), VkPhysicalDeviceHostImageCopyPropertiesEXT.__array(1, 16), VkPhysicalDeviceHostImageCopyPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COPYSRCLAYOUTCOUNT = layout.offsetof(2);
        PCOPYSRCLAYOUTS = layout.offsetof(3);
        COPYDSTLAYOUTCOUNT = layout.offsetof(4);
        PCOPYDSTLAYOUTS = layout.offsetof(5);
        OPTIMALTILINGLAYOUTUUID = layout.offsetof(6);
        IDENTICALMEMORYTYPEREQUIREMENTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceHostImageCopyPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceHostImageCopyPropertiesEXT ELEMENT_FACTORY = VkPhysicalDeviceHostImageCopyPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceHostImageCopyPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int copySrcLayoutCount() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageLayout *")
        public IntBuffer pCopySrcLayouts() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopySrcLayouts(this.address());
        }

        @NativeType(value="uint32_t")
        public int copyDstLayoutCount() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageLayout *")
        public IntBuffer pCopyDstLayouts() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopyDstLayouts(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer optimalTilingLayoutUUID() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte optimalTilingLayoutUUID(int index) {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), index);
        }

        @NativeType(value="VkBool32")
        public boolean identicalMemoryTypeRequirements() {
            return VkPhysicalDeviceHostImageCopyPropertiesEXT.nidenticalMemoryTypeRequirements(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer copySrcLayoutCount(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopySrcLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pCopySrcLayouts(@Nullable @NativeType(value="VkImageLayout *") IntBuffer value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopySrcLayouts(this.address(), value);
            return this;
        }

        public Buffer copyDstLayoutCount(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.ncopyDstLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pCopyDstLayouts(@Nullable @NativeType(value="VkImageLayout *") IntBuffer value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.npCopyDstLayouts(this.address(), value);
            return this;
        }

        public Buffer optimalTilingLayoutUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), value);
            return this;
        }

        public Buffer optimalTilingLayoutUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.noptimalTilingLayoutUUID(this.address(), index, value);
            return this;
        }

        public Buffer identicalMemoryTypeRequirements(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceHostImageCopyPropertiesEXT.nidenticalMemoryTypeRequirements(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

