/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMultiDrawInfoEXT
extends Struct<VkMultiDrawInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FIRSTVERTEX;
    public static final int VERTEXCOUNT;

    protected VkMultiDrawInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMultiDrawInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMultiDrawInfoEXT(address, container);
    }

    public VkMultiDrawInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMultiDrawInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int firstVertex() {
        return VkMultiDrawInfoEXT.nfirstVertex(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return VkMultiDrawInfoEXT.nvertexCount(this.address());
    }

    public VkMultiDrawInfoEXT firstVertex(@NativeType(value="uint32_t") int value) {
        VkMultiDrawInfoEXT.nfirstVertex(this.address(), value);
        return this;
    }

    public VkMultiDrawInfoEXT vertexCount(@NativeType(value="uint32_t") int value) {
        VkMultiDrawInfoEXT.nvertexCount(this.address(), value);
        return this;
    }

    public VkMultiDrawInfoEXT set(int firstVertex, int vertexCount) {
        this.firstVertex(firstVertex);
        this.vertexCount(vertexCount);
        return this;
    }

    public VkMultiDrawInfoEXT set(VkMultiDrawInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMultiDrawInfoEXT malloc() {
        return new VkMultiDrawInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMultiDrawInfoEXT calloc() {
        return new VkMultiDrawInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMultiDrawInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMultiDrawInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMultiDrawInfoEXT create(long address) {
        return new VkMultiDrawInfoEXT(address, null);
    }

    @Nullable
    public static VkMultiDrawInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMultiDrawInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMultiDrawInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMultiDrawInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMultiDrawInfoEXT malloc(MemoryStack stack) {
        return new VkMultiDrawInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMultiDrawInfoEXT calloc(MemoryStack stack) {
        return new VkMultiDrawInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfirstVertex(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRSTVERTEX);
    }

    public static int nvertexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNT);
    }

    public static void nfirstVertex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRSTVERTEX, value);
    }

    public static void nvertexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNT, value);
    }

    static {
        Struct.Layout layout = VkMultiDrawInfoEXT.__struct(VkMultiDrawInfoEXT.__member(4), VkMultiDrawInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FIRSTVERTEX = layout.offsetof(0);
        VERTEXCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMultiDrawInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMultiDrawInfoEXT ELEMENT_FACTORY = VkMultiDrawInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMultiDrawInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int firstVertex() {
            return VkMultiDrawInfoEXT.nfirstVertex(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return VkMultiDrawInfoEXT.nvertexCount(this.address());
        }

        public Buffer firstVertex(@NativeType(value="uint32_t") int value) {
            VkMultiDrawInfoEXT.nfirstVertex(this.address(), value);
            return this;
        }

        public Buffer vertexCount(@NativeType(value="uint32_t") int value) {
            VkMultiDrawInfoEXT.nvertexCount(this.address(), value);
            return this;
        }
    }
}

