/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMicromapCreateInfoEXT
extends Struct<VkMicromapCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CREATEFLAGS;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int TYPE;
    public static final int DEVICEADDRESS;

    protected VkMicromapCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMicromapCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapCreateInfoEXT(address, container);
    }

    public VkMicromapCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMicromapCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMicromapCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMicromapCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkMicromapCreateFlagsEXT")
    public int createFlags() {
        return VkMicromapCreateInfoEXT.ncreateFlags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkMicromapCreateInfoEXT.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMicromapCreateInfoEXT.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMicromapCreateInfoEXT.nsize(this.address());
    }

    @NativeType(value="VkMicromapTypeEXT")
    public int type() {
        return VkMicromapCreateInfoEXT.ntype(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkMicromapCreateInfoEXT.ndeviceAddress(this.address());
    }

    public VkMicromapCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMicromapCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT sType$Default() {
        return this.sType(1000396007);
    }

    public VkMicromapCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMicromapCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT createFlags(@NativeType(value="VkMicromapCreateFlagsEXT") int value) {
        VkMicromapCreateInfoEXT.ncreateFlags(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT buffer(@NativeType(value="VkBuffer") long value) {
        VkMicromapCreateInfoEXT.nbuffer(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT offset(@NativeType(value="VkDeviceSize") long value) {
        VkMicromapCreateInfoEXT.noffset(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT size(@NativeType(value="VkDeviceSize") long value) {
        VkMicromapCreateInfoEXT.nsize(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT type(@NativeType(value="VkMicromapTypeEXT") int value) {
        VkMicromapCreateInfoEXT.ntype(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkMicromapCreateInfoEXT.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkMicromapCreateInfoEXT set(int sType, long pNext, int createFlags, long buffer, long offset, long size, int type, long deviceAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.createFlags(createFlags);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        this.type(type);
        this.deviceAddress(deviceAddress);
        return this;
    }

    public VkMicromapCreateInfoEXT set(VkMicromapCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMicromapCreateInfoEXT malloc() {
        return new VkMicromapCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMicromapCreateInfoEXT calloc() {
        return new VkMicromapCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMicromapCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMicromapCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMicromapCreateInfoEXT create(long address) {
        return new VkMicromapCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkMicromapCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMicromapCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapCreateInfoEXT malloc(MemoryStack stack) {
        return new VkMicromapCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapCreateInfoEXT calloc(MemoryStack stack) {
        return new VkMicromapCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncreateFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)CREATEFLAGS);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncreateFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CREATEFLAGS, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    static {
        Struct.Layout layout = VkMicromapCreateInfoEXT.__struct(VkMicromapCreateInfoEXT.__member(4), VkMicromapCreateInfoEXT.__member(POINTER_SIZE), VkMicromapCreateInfoEXT.__member(4), VkMicromapCreateInfoEXT.__member(8), VkMicromapCreateInfoEXT.__member(8), VkMicromapCreateInfoEXT.__member(8), VkMicromapCreateInfoEXT.__member(4), VkMicromapCreateInfoEXT.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
        TYPE = layout.offsetof(6);
        DEVICEADDRESS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapCreateInfoEXT ELEMENT_FACTORY = VkMicromapCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMicromapCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMicromapCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMicromapCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkMicromapCreateFlagsEXT")
        public int createFlags() {
            return VkMicromapCreateInfoEXT.ncreateFlags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkMicromapCreateInfoEXT.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMicromapCreateInfoEXT.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMicromapCreateInfoEXT.nsize(this.address());
        }

        @NativeType(value="VkMicromapTypeEXT")
        public int type() {
            return VkMicromapCreateInfoEXT.ntype(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkMicromapCreateInfoEXT.ndeviceAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMicromapCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMicromapCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="VkMicromapCreateFlagsEXT") int value) {
            VkMicromapCreateInfoEXT.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMicromapCreateInfoEXT.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMicromapCreateInfoEXT.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMicromapCreateInfoEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkMicromapTypeEXT") int value) {
            VkMicromapCreateInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkMicromapCreateInfoEXT.ndeviceAddress(this.address(), value);
            return this;
        }
    }
}

