/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryWin32HandleInfoKHR
extends Struct<VkImportMemoryWin32HandleInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int HANDLE;
    public static final int NAME;

    protected VkImportMemoryWin32HandleInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImportMemoryWin32HandleInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkImportMemoryWin32HandleInfoKHR(address, container);
    }

    public VkImportMemoryWin32HandleInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImportMemoryWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryWin32HandleInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkImportMemoryWin32HandleInfoKHR.nhandleType(this.address());
    }

    @NativeType(value="HANDLE")
    public long handle() {
        return VkImportMemoryWin32HandleInfoKHR.nhandle(this.address());
    }

    @NativeType(value="LPCWSTR")
    public ByteBuffer name() {
        return VkImportMemoryWin32HandleInfoKHR.nname(this.address());
    }

    @NativeType(value="LPCWSTR")
    public String nameString() {
        return VkImportMemoryWin32HandleInfoKHR.nnameString(this.address());
    }

    public VkImportMemoryWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR sType$Default() {
        return this.sType(1000073000);
    }

    public VkImportMemoryWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkImportMemoryWin32HandleInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR handle(@NativeType(value="HANDLE") long value) {
        VkImportMemoryWin32HandleInfoKHR.nhandle(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR name(@NativeType(value="LPCWSTR") ByteBuffer value) {
        VkImportMemoryWin32HandleInfoKHR.nname(this.address(), value);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR set(int sType, long pNext, int handleType, long handle, ByteBuffer name) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.handle(handle);
        this.name(name);
        return this;
    }

    public VkImportMemoryWin32HandleInfoKHR set(VkImportMemoryWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryWin32HandleInfoKHR malloc() {
        return new VkImportMemoryWin32HandleInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoKHR calloc() {
        return new VkImportMemoryWin32HandleInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImportMemoryWin32HandleInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkImportMemoryWin32HandleInfoKHR create(long address) {
        return new VkImportMemoryWin32HandleInfoKHR(address, null);
    }

    @Nullable
    public static VkImportMemoryWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkImportMemoryWin32HandleInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImportMemoryWin32HandleInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryWin32HandleInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoKHR mallocStack() {
        return VkImportMemoryWin32HandleInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoKHR callocStack() {
        return VkImportMemoryWin32HandleInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkImportMemoryWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportMemoryWin32HandleInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryWin32HandleInfoKHR.calloc(capacity, stack);
    }

    public static VkImportMemoryWin32HandleInfoKHR malloc(MemoryStack stack) {
        return new VkImportMemoryWin32HandleInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMemoryWin32HandleInfoKHR calloc(MemoryStack stack) {
        return new VkImportMemoryWin32HandleInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = VkImportMemoryWin32HandleInfoKHR.__struct(VkImportMemoryWin32HandleInfoKHR.__member(4), VkImportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportMemoryWin32HandleInfoKHR.__member(4), VkImportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE), VkImportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
        NAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        private static final VkImportMemoryWin32HandleInfoKHR ELEMENT_FACTORY = VkImportMemoryWin32HandleInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImportMemoryWin32HandleInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryWin32HandleInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkImportMemoryWin32HandleInfoKHR.nhandleType(this.address());
        }

        @NativeType(value="HANDLE")
        public long handle() {
            return VkImportMemoryWin32HandleInfoKHR.nhandle(this.address());
        }

        @NativeType(value="LPCWSTR")
        public ByteBuffer name() {
            return VkImportMemoryWin32HandleInfoKHR.nname(this.address());
        }

        @NativeType(value="LPCWSTR")
        public String nameString() {
            return VkImportMemoryWin32HandleInfoKHR.nnameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000073000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkImportMemoryWin32HandleInfoKHR.nhandleType(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="HANDLE") long value) {
            VkImportMemoryWin32HandleInfoKHR.nhandle(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="LPCWSTR") ByteBuffer value) {
            VkImportMemoryWin32HandleInfoKHR.nname(this.address(), value);
            return this;
        }
    }
}

