/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDirectFBSurfaceCreateInfoEXT
extends Struct<VkDirectFBSurfaceCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DFB;
    public static final int SURFACE;

    protected VkDirectFBSurfaceCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDirectFBSurfaceCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDirectFBSurfaceCreateInfoEXT(address, container);
    }

    public VkDirectFBSurfaceCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDirectFBSurfaceCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDirectFBSurfaceCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDirectFBSurfaceCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDirectFBSurfaceCreateFlagsEXT")
    public int flags() {
        return VkDirectFBSurfaceCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="IDirectFB *")
    public long dfb() {
        return VkDirectFBSurfaceCreateInfoEXT.ndfb(this.address());
    }

    @NativeType(value="IDirectFBSurface *")
    public long surface() {
        return VkDirectFBSurfaceCreateInfoEXT.nsurface(this.address());
    }

    public VkDirectFBSurfaceCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDirectFBSurfaceCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT sType$Default() {
        return this.sType(1000346000);
    }

    public VkDirectFBSurfaceCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDirectFBSurfaceCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT flags(@NativeType(value="VkDirectFBSurfaceCreateFlagsEXT") int value) {
        VkDirectFBSurfaceCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT dfb(@NativeType(value="IDirectFB *") long value) {
        VkDirectFBSurfaceCreateInfoEXT.ndfb(this.address(), value);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT surface(@NativeType(value="IDirectFBSurface *") long value) {
        VkDirectFBSurfaceCreateInfoEXT.nsurface(this.address(), value);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT set(int sType, long pNext, int flags, long dfb, long surface) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dfb(dfb);
        this.surface(surface);
        return this;
    }

    public VkDirectFBSurfaceCreateInfoEXT set(VkDirectFBSurfaceCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDirectFBSurfaceCreateInfoEXT malloc() {
        return new VkDirectFBSurfaceCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDirectFBSurfaceCreateInfoEXT calloc() {
        return new VkDirectFBSurfaceCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDirectFBSurfaceCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDirectFBSurfaceCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDirectFBSurfaceCreateInfoEXT create(long address) {
        return new VkDirectFBSurfaceCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkDirectFBSurfaceCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDirectFBSurfaceCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDirectFBSurfaceCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDirectFBSurfaceCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDirectFBSurfaceCreateInfoEXT malloc(MemoryStack stack) {
        return new VkDirectFBSurfaceCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDirectFBSurfaceCreateInfoEXT calloc(MemoryStack stack) {
        return new VkDirectFBSurfaceCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndfb(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DFB);
    }

    public static long nsurface(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SURFACE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndfb(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DFB, value);
    }

    public static void nsurface(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SURFACE, value);
    }

    static {
        Struct.Layout layout = VkDirectFBSurfaceCreateInfoEXT.__struct(VkDirectFBSurfaceCreateInfoEXT.__member(4), VkDirectFBSurfaceCreateInfoEXT.__member(POINTER_SIZE), VkDirectFBSurfaceCreateInfoEXT.__member(4), VkDirectFBSurfaceCreateInfoEXT.__member(POINTER_SIZE), VkDirectFBSurfaceCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DFB = layout.offsetof(3);
        SURFACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDirectFBSurfaceCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDirectFBSurfaceCreateInfoEXT ELEMENT_FACTORY = VkDirectFBSurfaceCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDirectFBSurfaceCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDirectFBSurfaceCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDirectFBSurfaceCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDirectFBSurfaceCreateFlagsEXT")
        public int flags() {
            return VkDirectFBSurfaceCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="IDirectFB *")
        public long dfb() {
            return VkDirectFBSurfaceCreateInfoEXT.ndfb(this.address());
        }

        @NativeType(value="IDirectFBSurface *")
        public long surface() {
            return VkDirectFBSurfaceCreateInfoEXT.nsurface(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDirectFBSurfaceCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000346000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDirectFBSurfaceCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDirectFBSurfaceCreateFlagsEXT") int value) {
            VkDirectFBSurfaceCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer dfb(@NativeType(value="IDirectFB *") long value) {
            VkDirectFBSurfaceCreateInfoEXT.ndfb(this.address(), value);
            return this;
        }

        public Buffer surface(@NativeType(value="IDirectFBSurface *") long value) {
            VkDirectFBSurfaceCreateInfoEXT.nsurface(this.address(), value);
            return this;
        }
    }
}

