/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupBindSparseInfo
extends Struct<VkDeviceGroupBindSparseInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RESOURCEDEVICEINDEX;
    public static final int MEMORYDEVICEINDEX;

    protected VkDeviceGroupBindSparseInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceGroupBindSparseInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceGroupBindSparseInfo(address, container);
    }

    public VkDeviceGroupBindSparseInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceGroupBindSparseInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupBindSparseInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupBindSparseInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int resourceDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
    }

    public VkDeviceGroupBindSparseInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo sType$Default() {
        return this.sType(1000060006);
    }

    public VkDeviceGroupBindSparseInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(VkDeviceGroupBindSparseInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfo malloc() {
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo calloc() {
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceGroupBindSparseInfo create(long address) {
        return new VkDeviceGroupBindSparseInfo(address, null);
    }

    @Nullable
    public static VkDeviceGroupBindSparseInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceGroupBindSparseInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceGroupBindSparseInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupBindSparseInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo mallocStack() {
        return VkDeviceGroupBindSparseInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo callocStack() {
        return VkDeviceGroupBindSparseInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.calloc(capacity, stack);
    }

    public static VkDeviceGroupBindSparseInfo malloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo calloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nresourceDeviceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESOURCEDEVICEINDEX);
    }

    public static int nmemoryDeviceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYDEVICEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nresourceDeviceIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESOURCEDEVICEINDEX, value);
    }

    public static void nmemoryDeviceIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYDEVICEINDEX, value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupBindSparseInfo.__struct(VkDeviceGroupBindSparseInfo.__member(4), VkDeviceGroupBindSparseInfo.__member(POINTER_SIZE), VkDeviceGroupBindSparseInfo.__member(4), VkDeviceGroupBindSparseInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RESOURCEDEVICEINDEX = layout.offsetof(2);
        MEMORYDEVICEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupBindSparseInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupBindSparseInfo ELEMENT_FACTORY = VkDeviceGroupBindSparseInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceGroupBindSparseInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupBindSparseInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupBindSparseInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int resourceDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

