/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCuLaunchInfoNVX
extends Struct<VkCuLaunchInfoNVX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FUNCTION;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int PARAMCOUNT;
    public static final int PPARAMS;
    public static final int EXTRACOUNT;
    public static final int PEXTRAS;

    protected VkCuLaunchInfoNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCuLaunchInfoNVX create(long address, @Nullable ByteBuffer container) {
        return new VkCuLaunchInfoNVX(address, container);
    }

    public VkCuLaunchInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCuLaunchInfoNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuLaunchInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuLaunchInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkCuFunctionNVX")
    public long function() {
        return VkCuLaunchInfoNVX.nfunction(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimX() {
        return VkCuLaunchInfoNVX.ngridDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimY() {
        return VkCuLaunchInfoNVX.ngridDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimZ() {
        return VkCuLaunchInfoNVX.ngridDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimX() {
        return VkCuLaunchInfoNVX.nblockDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimY() {
        return VkCuLaunchInfoNVX.nblockDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimZ() {
        return VkCuLaunchInfoNVX.nblockDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int sharedMemBytes() {
        return VkCuLaunchInfoNVX.nsharedMemBytes(this.address());
    }

    @NativeType(value="size_t")
    public long paramCount() {
        return VkCuLaunchInfoNVX.nparamCount(this.address());
    }

    @Nullable
    @NativeType(value="void const * const *")
    public PointerBuffer pParams() {
        return VkCuLaunchInfoNVX.npParams(this.address());
    }

    @NativeType(value="size_t")
    public long extraCount() {
        return VkCuLaunchInfoNVX.nextraCount(this.address());
    }

    @Nullable
    @NativeType(value="void const * const *")
    public PointerBuffer pExtras() {
        return VkCuLaunchInfoNVX.npExtras(this.address());
    }

    public VkCuLaunchInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuLaunchInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX sType$Default() {
        return this.sType(1000029002);
    }

    public VkCuLaunchInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuLaunchInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX function(@NativeType(value="VkCuFunctionNVX") long value) {
        VkCuLaunchInfoNVX.nfunction(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimX(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimX(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimY(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimY(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimZ(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimZ(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimX(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimX(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimY(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimY(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimZ(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimZ(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX sharedMemBytes(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nsharedMemBytes(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX pParams(@Nullable @NativeType(value="void const * const *") PointerBuffer value) {
        VkCuLaunchInfoNVX.npParams(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX pExtras(@Nullable @NativeType(value="void const * const *") PointerBuffer value) {
        VkCuLaunchInfoNVX.npExtras(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX set(int sType, long pNext, long function, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, @Nullable PointerBuffer pParams, @Nullable PointerBuffer pExtras) {
        this.sType(sType);
        this.pNext(pNext);
        this.function(function);
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.pParams(pParams);
        this.pExtras(pExtras);
        return this;
    }

    public VkCuLaunchInfoNVX set(VkCuLaunchInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCuLaunchInfoNVX malloc() {
        return new VkCuLaunchInfoNVX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX calloc() {
        return new VkCuLaunchInfoNVX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCuLaunchInfoNVX(MemoryUtil.memAddress(container), container);
    }

    public static VkCuLaunchInfoNVX create(long address) {
        return new VkCuLaunchInfoNVX(address, null);
    }

    @Nullable
    public static VkCuLaunchInfoNVX createSafe(long address) {
        return address == 0L ? null : new VkCuLaunchInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCuLaunchInfoNVX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuLaunchInfoNVX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCuLaunchInfoNVX malloc(MemoryStack stack) {
        return new VkCuLaunchInfoNVX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX calloc(MemoryStack stack) {
        return new VkCuLaunchInfoNVX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nfunction(long struct) {
        return UNSAFE.getLong(null, struct + (long)FUNCTION);
    }

    public static int ngridDimX(long struct) {
        return UNSAFE.getInt(null, struct + (long)GRIDDIMX);
    }

    public static int ngridDimY(long struct) {
        return UNSAFE.getInt(null, struct + (long)GRIDDIMY);
    }

    public static int ngridDimZ(long struct) {
        return UNSAFE.getInt(null, struct + (long)GRIDDIMZ);
    }

    public static int nblockDimX(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKDIMX);
    }

    public static int nblockDimY(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKDIMY);
    }

    public static int nblockDimZ(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKDIMZ);
    }

    public static int nsharedMemBytes(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHAREDMEMBYTES);
    }

    public static long nparamCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PARAMCOUNT);
    }

    @Nullable
    public static PointerBuffer npParams(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPARAMS), (int)VkCuLaunchInfoNVX.nparamCount(struct));
    }

    public static long nextraCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)EXTRACOUNT);
    }

    @Nullable
    public static PointerBuffer npExtras(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PEXTRAS), (int)VkCuLaunchInfoNVX.nextraCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nfunction(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FUNCTION, value);
    }

    public static void ngridDimX(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GRIDDIMX, value);
    }

    public static void ngridDimY(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GRIDDIMY, value);
    }

    public static void ngridDimZ(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GRIDDIMZ, value);
    }

    public static void nblockDimX(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BLOCKDIMX, value);
    }

    public static void nblockDimY(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BLOCKDIMY, value);
    }

    public static void nblockDimZ(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BLOCKDIMZ, value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHAREDMEMBYTES, value);
    }

    public static void nparamCount(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PARAMCOUNT, value);
    }

    public static void npParams(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPARAMS, MemoryUtil.memAddressSafe(value));
        VkCuLaunchInfoNVX.nparamCount(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void nextraCount(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)EXTRACOUNT, value);
    }

    public static void npExtras(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PEXTRAS, MemoryUtil.memAddressSafe(value));
        VkCuLaunchInfoNVX.nextraCount(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkCuLaunchInfoNVX.nparamCount(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPARAMS));
        }
        if (VkCuLaunchInfoNVX.nextraCount(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PEXTRAS));
        }
    }

    static {
        Struct.Layout layout = VkCuLaunchInfoNVX.__struct(VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(POINTER_SIZE), VkCuLaunchInfoNVX.__member(8), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(4), VkCuLaunchInfoNVX.__member(POINTER_SIZE), VkCuLaunchInfoNVX.__member(POINTER_SIZE), VkCuLaunchInfoNVX.__member(POINTER_SIZE), VkCuLaunchInfoNVX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FUNCTION = layout.offsetof(2);
        GRIDDIMX = layout.offsetof(3);
        GRIDDIMY = layout.offsetof(4);
        GRIDDIMZ = layout.offsetof(5);
        BLOCKDIMX = layout.offsetof(6);
        BLOCKDIMY = layout.offsetof(7);
        BLOCKDIMZ = layout.offsetof(8);
        SHAREDMEMBYTES = layout.offsetof(9);
        PARAMCOUNT = layout.offsetof(10);
        PPARAMS = layout.offsetof(11);
        EXTRACOUNT = layout.offsetof(12);
        PEXTRAS = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<VkCuLaunchInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuLaunchInfoNVX ELEMENT_FACTORY = VkCuLaunchInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCuLaunchInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuLaunchInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuLaunchInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkCuFunctionNVX")
        public long function() {
            return VkCuLaunchInfoNVX.nfunction(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimX() {
            return VkCuLaunchInfoNVX.ngridDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimY() {
            return VkCuLaunchInfoNVX.ngridDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimZ() {
            return VkCuLaunchInfoNVX.ngridDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimX() {
            return VkCuLaunchInfoNVX.nblockDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimY() {
            return VkCuLaunchInfoNVX.nblockDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimZ() {
            return VkCuLaunchInfoNVX.nblockDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int sharedMemBytes() {
            return VkCuLaunchInfoNVX.nsharedMemBytes(this.address());
        }

        @NativeType(value="size_t")
        public long paramCount() {
            return VkCuLaunchInfoNVX.nparamCount(this.address());
        }

        @Nullable
        @NativeType(value="void const * const *")
        public PointerBuffer pParams() {
            return VkCuLaunchInfoNVX.npParams(this.address());
        }

        @NativeType(value="size_t")
        public long extraCount() {
            return VkCuLaunchInfoNVX.nextraCount(this.address());
        }

        @Nullable
        @NativeType(value="void const * const *")
        public PointerBuffer pExtras() {
            return VkCuLaunchInfoNVX.npExtras(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuLaunchInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuLaunchInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer function(@NativeType(value="VkCuFunctionNVX") long value) {
            VkCuLaunchInfoNVX.nfunction(this.address(), value);
            return this;
        }

        public Buffer gridDimX(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer pParams(@Nullable @NativeType(value="void const * const *") PointerBuffer value) {
            VkCuLaunchInfoNVX.npParams(this.address(), value);
            return this;
        }

        public Buffer pExtras(@Nullable @NativeType(value="void const * const *") PointerBuffer value) {
            VkCuLaunchInfoNVX.npExtras(this.address(), value);
            return this;
        }
    }
}

