/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryToImageCopyEXT;

public class VkCopyMemoryToImageInfoEXT
extends Struct<VkCopyMemoryToImageInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyMemoryToImageInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyMemoryToImageInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToImageInfoEXT(address, container);
    }

    public VkCopyMemoryToImageInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCopyMemoryToImageInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyMemoryToImageInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyMemoryToImageInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlagsEXT")
    public int flags() {
        return VkCopyMemoryToImageInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyMemoryToImageInfoEXT.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyMemoryToImageInfoEXT.nregionCount(this.address());
    }

    @NativeType(value="VkMemoryToImageCopyEXT const *")
    public VkMemoryToImageCopyEXT.Buffer pRegions() {
        return VkCopyMemoryToImageInfoEXT.npRegions(this.address());
    }

    public VkCopyMemoryToImageInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMemoryToImageInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT sType$Default() {
        return this.sType(1000270005);
    }

    public VkCopyMemoryToImageInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyMemoryToImageInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
        VkCopyMemoryToImageInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT dstImage(@NativeType(value="VkImage") long value) {
        VkCopyMemoryToImageInfoEXT.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT pRegions(@NativeType(value="VkMemoryToImageCopyEXT const *") VkMemoryToImageCopyEXT.Buffer value) {
        VkCopyMemoryToImageInfoEXT.npRegions(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT set(int sType, long pNext, int flags, long dstImage, int dstImageLayout, VkMemoryToImageCopyEXT.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT set(VkCopyMemoryToImageInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyMemoryToImageInfoEXT malloc() {
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT calloc() {
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyMemoryToImageInfoEXT create(long address) {
        return new VkCopyMemoryToImageInfoEXT(address, null);
    }

    @Nullable
    public static VkCopyMemoryToImageInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToImageInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyMemoryToImageInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToImageInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToImageInfoEXT malloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT calloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndstImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTIMAGE);
    }

    public static int ndstImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkMemoryToImageCopyEXT.Buffer npRegions(long struct) {
        return VkMemoryToImageCopyEXT.create(MemoryUtil.memGetAddress(struct + (long)PREGIONS), VkCopyMemoryToImageInfoEXT.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndstImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTIMAGE, value);
    }

    public static void ndstImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkMemoryToImageCopyEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREGIONS, value.address());
        VkCopyMemoryToImageInfoEXT.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int regionCount = VkCopyMemoryToImageInfoEXT.nregionCount(struct);
        long pRegions = MemoryUtil.memGetAddress(struct + (long)PREGIONS);
        Checks.check(pRegions);
        VkCopyMemoryToImageInfoEXT.validate(pRegions, regionCount, VkMemoryToImageCopyEXT.SIZEOF, VkMemoryToImageCopyEXT::validate);
    }

    static {
        Struct.Layout layout = VkCopyMemoryToImageInfoEXT.__struct(VkCopyMemoryToImageInfoEXT.__member(4), VkCopyMemoryToImageInfoEXT.__member(POINTER_SIZE), VkCopyMemoryToImageInfoEXT.__member(4), VkCopyMemoryToImageInfoEXT.__member(8), VkCopyMemoryToImageInfoEXT.__member(4), VkCopyMemoryToImageInfoEXT.__member(4), VkCopyMemoryToImageInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DSTIMAGE = layout.offsetof(3);
        DSTIMAGELAYOUT = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryToImageInfoEXT, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryToImageInfoEXT ELEMENT_FACTORY = VkCopyMemoryToImageInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkCopyMemoryToImageInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyMemoryToImageInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyMemoryToImageInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlagsEXT")
        public int flags() {
            return VkCopyMemoryToImageInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyMemoryToImageInfoEXT.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyMemoryToImageInfoEXT.nregionCount(this.address());
        }

        @NativeType(value="VkMemoryToImageCopyEXT const *")
        public VkMemoryToImageCopyEXT.Buffer pRegions() {
            return VkCopyMemoryToImageInfoEXT.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMemoryToImageInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMemoryToImageInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlagsEXT") int value) {
            VkCopyMemoryToImageInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyMemoryToImageInfoEXT.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkMemoryToImageCopyEXT const *") VkMemoryToImageCopyEXT.Buffer value) {
            VkCopyMemoryToImageInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

