/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCaptureDescriptorDataInfoEXT
extends Struct<VkBufferCaptureDescriptorDataInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;

    protected VkBufferCaptureDescriptorDataInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferCaptureDescriptorDataInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkBufferCaptureDescriptorDataInfoEXT(address, container);
    }

    public VkBufferCaptureDescriptorDataInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferCaptureDescriptorDataInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferCaptureDescriptorDataInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferCaptureDescriptorDataInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferCaptureDescriptorDataInfoEXT.nbuffer(this.address());
    }

    public VkBufferCaptureDescriptorDataInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCaptureDescriptorDataInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkBufferCaptureDescriptorDataInfoEXT sType$Default() {
        return this.sType(1000316005);
    }

    public VkBufferCaptureDescriptorDataInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkBufferCaptureDescriptorDataInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkBufferCaptureDescriptorDataInfoEXT buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferCaptureDescriptorDataInfoEXT.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferCaptureDescriptorDataInfoEXT set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferCaptureDescriptorDataInfoEXT set(VkBufferCaptureDescriptorDataInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCaptureDescriptorDataInfoEXT malloc() {
        return new VkBufferCaptureDescriptorDataInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferCaptureDescriptorDataInfoEXT calloc() {
        return new VkBufferCaptureDescriptorDataInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferCaptureDescriptorDataInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferCaptureDescriptorDataInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferCaptureDescriptorDataInfoEXT create(long address) {
        return new VkBufferCaptureDescriptorDataInfoEXT(address, null);
    }

    @Nullable
    public static VkBufferCaptureDescriptorDataInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkBufferCaptureDescriptorDataInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferCaptureDescriptorDataInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCaptureDescriptorDataInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferCaptureDescriptorDataInfoEXT malloc(MemoryStack stack) {
        return new VkBufferCaptureDescriptorDataInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferCaptureDescriptorDataInfoEXT calloc(MemoryStack stack) {
        return new VkBufferCaptureDescriptorDataInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkBufferCaptureDescriptorDataInfoEXT.__struct(VkBufferCaptureDescriptorDataInfoEXT.__member(4), VkBufferCaptureDescriptorDataInfoEXT.__member(POINTER_SIZE), VkBufferCaptureDescriptorDataInfoEXT.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCaptureDescriptorDataInfoEXT, Buffer>
    implements NativeResource {
        private static final VkBufferCaptureDescriptorDataInfoEXT ELEMENT_FACTORY = VkBufferCaptureDescriptorDataInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferCaptureDescriptorDataInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferCaptureDescriptorDataInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferCaptureDescriptorDataInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferCaptureDescriptorDataInfoEXT.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCaptureDescriptorDataInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000316005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCaptureDescriptorDataInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferCaptureDescriptorDataInfoEXT.nbuffer(this.address(), value);
            return this;
        }
    }
}

