/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfo;

public class VkBindImagePlaneMemoryInfoKHR
extends VkBindImagePlaneMemoryInfo {
    protected VkBindImagePlaneMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindImagePlaneMemoryInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkBindImagePlaneMemoryInfoKHR(address, container);
    }

    public VkBindImagePlaneMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR sType$Default() {
        return this.sType(1000156002);
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkBindImagePlaneMemoryInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfoKHR set(VkBindImagePlaneMemoryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc() {
        return new VkBindImagePlaneMemoryInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc() {
        return new VkBindImagePlaneMemoryInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindImagePlaneMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindImagePlaneMemoryInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkBindImagePlaneMemoryInfoKHR create(long address) {
        return new VkBindImagePlaneMemoryInfoKHR(address, null);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkBindImagePlaneMemoryInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindImagePlaneMemoryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImagePlaneMemoryInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR mallocStack() {
        return VkBindImagePlaneMemoryInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR callocStack() {
        return VkBindImagePlaneMemoryInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkBindImagePlaneMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImagePlaneMemoryInfoKHR.calloc(capacity, stack);
    }

    public static VkBindImagePlaneMemoryInfoKHR malloc(MemoryStack stack) {
        return new VkBindImagePlaneMemoryInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindImagePlaneMemoryInfoKHR calloc(MemoryStack stack) {
        return new VkBindImagePlaneMemoryInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindImagePlaneMemoryInfo.Buffer {
        private static final VkBindImagePlaneMemoryInfoKHR ELEMENT_FACTORY = VkBindImagePlaneMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBindImagePlaneMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000156002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

