/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_octasphere_mesh")
public class ParOctasphereMesh
extends Struct<ParOctasphereMesh>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITIONS;
    public static final int NORMALS;
    public static final int TEXCOORDS;
    public static final int INDICES;
    public static final int NUM_INDICES;
    public static final int NUM_VERTICES;

    protected ParOctasphereMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected ParOctasphereMesh create(long address, @Nullable ByteBuffer container) {
        return new ParOctasphereMesh(address, container);
    }

    public ParOctasphereMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), ParOctasphereMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer positions(int capacity) {
        return ParOctasphereMesh.npositions(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer normals(int capacity) {
        return ParOctasphereMesh.nnormals(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer texcoords(int capacity) {
        return ParOctasphereMesh.ntexcoords(this.address(), capacity);
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer indices(int capacity) {
        return ParOctasphereMesh.nindices(this.address(), capacity);
    }

    @NativeType(value="uint32_t")
    public int num_indices() {
        return ParOctasphereMesh.nnum_indices(this.address());
    }

    @NativeType(value="uint32_t")
    public int num_vertices() {
        return ParOctasphereMesh.nnum_vertices(this.address());
    }

    public ParOctasphereMesh positions(@NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.npositions(this.address(), value);
        return this;
    }

    public ParOctasphereMesh normals(@Nullable @NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.nnormals(this.address(), value);
        return this;
    }

    public ParOctasphereMesh texcoords(@Nullable @NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.ntexcoords(this.address(), value);
        return this;
    }

    public ParOctasphereMesh indices(@NativeType(value="uint16_t *") ShortBuffer value) {
        ParOctasphereMesh.nindices(this.address(), value);
        return this;
    }

    public ParOctasphereMesh set(FloatBuffer positions, @Nullable FloatBuffer normals, @Nullable FloatBuffer texcoords, ShortBuffer indices) {
        this.positions(positions);
        this.normals(normals);
        this.texcoords(texcoords);
        this.indices(indices);
        return this;
    }

    public ParOctasphereMesh set(ParOctasphereMesh src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static ParOctasphereMesh malloc() {
        return new ParOctasphereMesh(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ParOctasphereMesh calloc() {
        return new ParOctasphereMesh(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ParOctasphereMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new ParOctasphereMesh(MemoryUtil.memAddress(container), container);
    }

    public static ParOctasphereMesh create(long address) {
        return new ParOctasphereMesh(address, null);
    }

    @Nullable
    public static ParOctasphereMesh createSafe(long address) {
        return address == 0L ? null : new ParOctasphereMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(ParOctasphereMesh.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParOctasphereMesh.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ParOctasphereMesh malloc(MemoryStack stack) {
        return new ParOctasphereMesh(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ParOctasphereMesh calloc(MemoryStack stack) {
        return new ParOctasphereMesh(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer npositions(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)POSITIONS), capacity);
    }

    @Nullable
    public static FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)NORMALS), capacity);
    }

    @Nullable
    public static FloatBuffer ntexcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)TEXCOORDS), capacity);
    }

    public static ShortBuffer nindices(long struct, int capacity) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)INDICES), capacity);
    }

    public static int nnum_indices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_INDICES);
    }

    public static int nnum_vertices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_VERTICES);
    }

    public static void npositions(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)POSITIONS, MemoryUtil.memAddress(value));
    }

    public static void nnormals(long struct, @Nullable FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)NORMALS, MemoryUtil.memAddressSafe(value));
    }

    public static void ntexcoords(long struct, @Nullable FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)TEXCOORDS, MemoryUtil.memAddressSafe(value));
    }

    public static void nindices(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POSITIONS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDICES));
    }

    static {
        Struct.Layout layout = ParOctasphereMesh.__struct(ParOctasphereMesh.__member(POINTER_SIZE), ParOctasphereMesh.__member(POINTER_SIZE), ParOctasphereMesh.__member(POINTER_SIZE), ParOctasphereMesh.__member(POINTER_SIZE), ParOctasphereMesh.__member(4), ParOctasphereMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITIONS = layout.offsetof(0);
        NORMALS = layout.offsetof(1);
        TEXCOORDS = layout.offsetof(2);
        INDICES = layout.offsetof(3);
        NUM_INDICES = layout.offsetof(4);
        NUM_VERTICES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ParOctasphereMesh, Buffer>
    implements NativeResource {
        private static final ParOctasphereMesh ELEMENT_FACTORY = ParOctasphereMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ParOctasphereMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer positions(int capacity) {
            return ParOctasphereMesh.npositions(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer normals(int capacity) {
            return ParOctasphereMesh.nnormals(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer texcoords(int capacity) {
            return ParOctasphereMesh.ntexcoords(this.address(), capacity);
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer indices(int capacity) {
            return ParOctasphereMesh.nindices(this.address(), capacity);
        }

        @NativeType(value="uint32_t")
        public int num_indices() {
            return ParOctasphereMesh.nnum_indices(this.address());
        }

        @NativeType(value="uint32_t")
        public int num_vertices() {
            return ParOctasphereMesh.nnum_vertices(this.address());
        }

        public Buffer positions(@NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.npositions(this.address(), value);
            return this;
        }

        public Buffer normals(@Nullable @NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.nnormals(this.address(), value);
            return this;
        }

        public Buffer texcoords(@Nullable @NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.ntexcoords(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="uint16_t *") ShortBuffer value) {
            ParOctasphereMesh.nindices(this.address(), value);
            return this;
        }
    }
}

