/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkValidationCacheCreateInfoEXT
extends Struct<VkValidationCacheCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int INITIALDATASIZE;
    public static final int PINITIALDATA;

    protected VkValidationCacheCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkValidationCacheCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkValidationCacheCreateInfoEXT(address, container);
    }

    public VkValidationCacheCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkValidationCacheCreateInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkValidationCacheCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkValidationCacheCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkValidationCacheCreateFlagsEXT")
    public int flags() {
        return VkValidationCacheCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="size_t")
    public long initialDataSize() {
        return VkValidationCacheCreateInfoEXT.ninitialDataSize(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer pInitialData() {
        return VkValidationCacheCreateInfoEXT.npInitialData(this.address());
    }

    public VkValidationCacheCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkValidationCacheCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkValidationCacheCreateInfoEXT sType$Default() {
        return this.sType(1000160000);
    }

    public VkValidationCacheCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkValidationCacheCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkValidationCacheCreateInfoEXT flags(@NativeType(value="VkValidationCacheCreateFlagsEXT") int value) {
        VkValidationCacheCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkValidationCacheCreateInfoEXT pInitialData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        VkValidationCacheCreateInfoEXT.npInitialData(this.address(), value);
        return this;
    }

    public VkValidationCacheCreateInfoEXT set(int sType, long pNext, int flags, @Nullable ByteBuffer pInitialData) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pInitialData(pInitialData);
        return this;
    }

    public VkValidationCacheCreateInfoEXT set(VkValidationCacheCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkValidationCacheCreateInfoEXT malloc() {
        return new VkValidationCacheCreateInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkValidationCacheCreateInfoEXT calloc() {
        return new VkValidationCacheCreateInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkValidationCacheCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkValidationCacheCreateInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkValidationCacheCreateInfoEXT create(long address) {
        return new VkValidationCacheCreateInfoEXT(address, null);
    }

    @Nullable
    public static VkValidationCacheCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkValidationCacheCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkValidationCacheCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkValidationCacheCreateInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkValidationCacheCreateInfoEXT mallocStack() {
        return VkValidationCacheCreateInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationCacheCreateInfoEXT callocStack() {
        return VkValidationCacheCreateInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkValidationCacheCreateInfoEXT mallocStack(MemoryStack stack) {
        return VkValidationCacheCreateInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkValidationCacheCreateInfoEXT callocStack(MemoryStack stack) {
        return VkValidationCacheCreateInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkValidationCacheCreateInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkValidationCacheCreateInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkValidationCacheCreateInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkValidationCacheCreateInfoEXT.calloc(capacity, stack);
    }

    public static VkValidationCacheCreateInfoEXT malloc(MemoryStack stack) {
        return new VkValidationCacheCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkValidationCacheCreateInfoEXT calloc(MemoryStack stack) {
        return new VkValidationCacheCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ninitialDataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INITIALDATASIZE);
    }

    @Nullable
    public static ByteBuffer npInitialData(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PINITIALDATA), (int)VkValidationCacheCreateInfoEXT.ninitialDataSize(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ninitialDataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)INITIALDATASIZE, value);
    }

    public static void npInitialData(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINITIALDATA, MemoryUtil.memAddressSafe(value));
        VkValidationCacheCreateInfoEXT.ninitialDataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkValidationCacheCreateInfoEXT.ninitialDataSize(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINITIALDATA));
        }
    }

    static {
        Struct.Layout layout = VkValidationCacheCreateInfoEXT.__struct(VkValidationCacheCreateInfoEXT.__member(4), VkValidationCacheCreateInfoEXT.__member(POINTER_SIZE), VkValidationCacheCreateInfoEXT.__member(4), VkValidationCacheCreateInfoEXT.__member(POINTER_SIZE), VkValidationCacheCreateInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        INITIALDATASIZE = layout.offsetof(3);
        PINITIALDATA = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkValidationCacheCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkValidationCacheCreateInfoEXT ELEMENT_FACTORY = VkValidationCacheCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkValidationCacheCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkValidationCacheCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkValidationCacheCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkValidationCacheCreateFlagsEXT")
        public int flags() {
            return VkValidationCacheCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="size_t")
        public long initialDataSize() {
            return VkValidationCacheCreateInfoEXT.ninitialDataSize(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer pInitialData() {
            return VkValidationCacheCreateInfoEXT.npInitialData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkValidationCacheCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000160000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkValidationCacheCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkValidationCacheCreateFlagsEXT") int value) {
            VkValidationCacheCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer pInitialData(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            VkValidationCacheCreateInfoEXT.npInitialData(this.address(), value);
            return this;
        }
    }
}

