/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkTraceRaysIndirectCommandKHR
extends Struct<VkTraceRaysIndirectCommandKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    protected VkTraceRaysIndirectCommandKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkTraceRaysIndirectCommandKHR create(long address, @Nullable ByteBuffer container) {
        return new VkTraceRaysIndirectCommandKHR(address, container);
    }

    public VkTraceRaysIndirectCommandKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkTraceRaysIndirectCommandKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkTraceRaysIndirectCommandKHR.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkTraceRaysIndirectCommandKHR.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int depth() {
        return VkTraceRaysIndirectCommandKHR.ndepth(this.address());
    }

    public VkTraceRaysIndirectCommandKHR width(@NativeType(value="uint32_t") int value) {
        VkTraceRaysIndirectCommandKHR.nwidth(this.address(), value);
        return this;
    }

    public VkTraceRaysIndirectCommandKHR height(@NativeType(value="uint32_t") int value) {
        VkTraceRaysIndirectCommandKHR.nheight(this.address(), value);
        return this;
    }

    public VkTraceRaysIndirectCommandKHR depth(@NativeType(value="uint32_t") int value) {
        VkTraceRaysIndirectCommandKHR.ndepth(this.address(), value);
        return this;
    }

    public VkTraceRaysIndirectCommandKHR set(int width, int height, int depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public VkTraceRaysIndirectCommandKHR set(VkTraceRaysIndirectCommandKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkTraceRaysIndirectCommandKHR malloc() {
        return new VkTraceRaysIndirectCommandKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkTraceRaysIndirectCommandKHR calloc() {
        return new VkTraceRaysIndirectCommandKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkTraceRaysIndirectCommandKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkTraceRaysIndirectCommandKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkTraceRaysIndirectCommandKHR create(long address) {
        return new VkTraceRaysIndirectCommandKHR(address, null);
    }

    @Nullable
    public static VkTraceRaysIndirectCommandKHR createSafe(long address) {
        return address == 0L ? null : new VkTraceRaysIndirectCommandKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkTraceRaysIndirectCommandKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkTraceRaysIndirectCommandKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkTraceRaysIndirectCommandKHR malloc(MemoryStack stack) {
        return new VkTraceRaysIndirectCommandKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkTraceRaysIndirectCommandKHR calloc(MemoryStack stack) {
        return new VkTraceRaysIndirectCommandKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTH);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = VkTraceRaysIndirectCommandKHR.__struct(VkTraceRaysIndirectCommandKHR.__member(4), VkTraceRaysIndirectCommandKHR.__member(4), VkTraceRaysIndirectCommandKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkTraceRaysIndirectCommandKHR, Buffer>
    implements NativeResource {
        private static final VkTraceRaysIndirectCommandKHR ELEMENT_FACTORY = VkTraceRaysIndirectCommandKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkTraceRaysIndirectCommandKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkTraceRaysIndirectCommandKHR.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkTraceRaysIndirectCommandKHR.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int depth() {
            return VkTraceRaysIndirectCommandKHR.ndepth(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkTraceRaysIndirectCommandKHR.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkTraceRaysIndirectCommandKHR.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="uint32_t") int value) {
            VkTraceRaysIndirectCommandKHR.ndepth(this.address(), value);
            return this;
        }
    }
}

