/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkSubpassSampleLocationsEXT
extends Struct<VkSubpassSampleLocationsEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASSINDEX;
    public static final int SAMPLELOCATIONSINFO;

    protected VkSubpassSampleLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubpassSampleLocationsEXT create(long address, @Nullable ByteBuffer container) {
        return new VkSubpassSampleLocationsEXT(address, container);
    }

    public VkSubpassSampleLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubpassSampleLocationsEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpassIndex() {
        return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkSubpassSampleLocationsEXT subpassIndex(@NativeType(value="uint32_t") int value) {
        VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkSubpassSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkSubpassSampleLocationsEXT set(int subpassIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.subpassIndex(subpassIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkSubpassSampleLocationsEXT set(VkSubpassSampleLocationsEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassSampleLocationsEXT malloc() {
        return new VkSubpassSampleLocationsEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubpassSampleLocationsEXT calloc() {
        return new VkSubpassSampleLocationsEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubpassSampleLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubpassSampleLocationsEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassSampleLocationsEXT create(long address) {
        return new VkSubpassSampleLocationsEXT(address, null);
    }

    @Nullable
    public static VkSubpassSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : new VkSubpassSampleLocationsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubpassSampleLocationsEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassSampleLocationsEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT mallocStack() {
        return VkSubpassSampleLocationsEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT callocStack() {
        return VkSubpassSampleLocationsEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT mallocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.malloc(stack);
    }

    @Deprecated
    public static VkSubpassSampleLocationsEXT callocStack(MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassSampleLocationsEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassSampleLocationsEXT.calloc(capacity, stack);
    }

    public static VkSubpassSampleLocationsEXT malloc(MemoryStack stack) {
        return new VkSubpassSampleLocationsEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubpassSampleLocationsEXT calloc(MemoryStack stack) {
        return new VkSubpassSampleLocationsEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsubpassIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASSINDEX);
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nsubpassIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASSINDEX, value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SAMPLELOCATIONSINFO, VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    static {
        Struct.Layout layout = VkSubpassSampleLocationsEXT.__struct(VkSubpassSampleLocationsEXT.__member(4), VkSubpassSampleLocationsEXT.__member(VkSampleLocationsInfoEXT.SIZEOF, VkSampleLocationsInfoEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASSINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassSampleLocationsEXT, Buffer>
    implements NativeResource {
        private static final VkSubpassSampleLocationsEXT ELEMENT_FACTORY = VkSubpassSampleLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubpassSampleLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int subpassIndex() {
            return VkSubpassSampleLocationsEXT.nsubpassIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer subpassIndex(@NativeType(value="uint32_t") int value) {
            VkSubpassSampleLocationsEXT.nsubpassIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkSubpassSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }
    }
}

