/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPipelineRenderingCreateInfo;

public class VkPipelineRenderingCreateInfoKHR
extends VkPipelineRenderingCreateInfo {
    protected VkPipelineRenderingCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineRenderingCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineRenderingCreateInfoKHR(address, container);
    }

    public VkPipelineRenderingCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineRenderingCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR sType$Default() {
        return this.sType(1000044002);
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineRenderingCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR viewMask(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfoKHR.nviewMask(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfoKHR.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkPipelineRenderingCreateInfoKHR.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfoKHR.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfoKHR.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkPipelineRenderingCreateInfoKHR set(int sType, long pNext, int viewMask, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkPipelineRenderingCreateInfoKHR set(VkPipelineRenderingCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineRenderingCreateInfoKHR malloc() {
        return new VkPipelineRenderingCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfoKHR calloc() {
        return new VkPipelineRenderingCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineRenderingCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineRenderingCreateInfoKHR create(long address) {
        return new VkPipelineRenderingCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkPipelineRenderingCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineRenderingCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineRenderingCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineRenderingCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineRenderingCreateInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineRenderingCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineRenderingCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPipelineRenderingCreateInfo.Buffer {
        private static final VkPipelineRenderingCreateInfoKHR ELEMENT_FACTORY = VkPipelineRenderingCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineRenderingCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineRenderingCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000044002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineRenderingCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfoKHR.nviewMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfoKHR.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        @Override
        public Buffer pColorAttachmentFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkPipelineRenderingCreateInfoKHR.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        @Override
        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfoKHR.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        @Override
        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfoKHR.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

