/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceSparseProperties
extends Struct<VkPhysicalDeviceSparseProperties> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESIDENCYSTANDARD2DBLOCKSHAPE;
    public static final int RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE;
    public static final int RESIDENCYSTANDARD3DBLOCKSHAPE;
    public static final int RESIDENCYALIGNEDMIPSIZE;
    public static final int RESIDENCYNONRESIDENTSTRICT;

    protected VkPhysicalDeviceSparseProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceSparseProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceSparseProperties(address, container);
    }

    public VkPhysicalDeviceSparseProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceSparseProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBool32")
    public boolean residencyStandard2DBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard2DBlockShape(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean residencyStandard2DMultisampleBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard2DMultisampleBlockShape(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean residencyStandard3DBlockShape() {
        return VkPhysicalDeviceSparseProperties.nresidencyStandard3DBlockShape(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean residencyAlignedMipSize() {
        return VkPhysicalDeviceSparseProperties.nresidencyAlignedMipSize(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean residencyNonResidentStrict() {
        return VkPhysicalDeviceSparseProperties.nresidencyNonResidentStrict(this.address()) != 0;
    }

    public static VkPhysicalDeviceSparseProperties create(long address) {
        return new VkPhysicalDeviceSparseProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceSparseProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceSparseProperties(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nresidencyStandard2DBlockShape(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESIDENCYSTANDARD2DBLOCKSHAPE);
    }

    public static int nresidencyStandard2DMultisampleBlockShape(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE);
    }

    public static int nresidencyStandard3DBlockShape(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESIDENCYSTANDARD3DBLOCKSHAPE);
    }

    public static int nresidencyAlignedMipSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESIDENCYALIGNEDMIPSIZE);
    }

    public static int nresidencyNonResidentStrict(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESIDENCYNONRESIDENTSTRICT);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceSparseProperties.__struct(VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4), VkPhysicalDeviceSparseProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESIDENCYSTANDARD2DBLOCKSHAPE = layout.offsetof(0);
        RESIDENCYSTANDARD2DMULTISAMPLEBLOCKSHAPE = layout.offsetof(1);
        RESIDENCYSTANDARD3DBLOCKSHAPE = layout.offsetof(2);
        RESIDENCYALIGNEDMIPSIZE = layout.offsetof(3);
        RESIDENCYNONRESIDENTSTRICT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceSparseProperties, Buffer> {
        private static final VkPhysicalDeviceSparseProperties ELEMENT_FACTORY = VkPhysicalDeviceSparseProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceSparseProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBool32")
        public boolean residencyStandard2DBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard2DBlockShape(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean residencyStandard2DMultisampleBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard2DMultisampleBlockShape(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean residencyStandard3DBlockShape() {
            return VkPhysicalDeviceSparseProperties.nresidencyStandard3DBlockShape(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean residencyAlignedMipSize() {
            return VkPhysicalDeviceSparseProperties.nresidencyAlignedMipSize(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean residencyNonResidentStrict() {
            return VkPhysicalDeviceSparseProperties.nresidencyNonResidentStrict(this.address()) != 0;
        }
    }
}

